﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BLSpaceRay.Renderer;
using BLSpaceRay.Math3D;

namespace TestApp
{
    public partial class frmMain : Form
    {
        bool m_Running = true;
        Renderer m_Renderer;

        public frmMain()
        {
            InitializeComponent();

            // Init the Scene
            InitScene();
        }

        private void frmMain_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Escape:
                    m_Running = false;
                    Application.Exit();
                    break;
                case Keys.Enter:
                    DrawWindow();
                    break;
            }
        }

        private void InitScene()
        {
            int mat = 0;
            int tex = 0;
            // init the Scene
            m_Renderer = new Renderer(this.Width, this.Height);
            // Set up the View
            m_Renderer.SetLookAt(new Vector3(2, 10, 15), new Vector3(-1, 2, 0), new Vector3(0, 1, 0));
            // Set the Back Color
            m_Renderer.m_BackColor = new Colorf(1, 0, 0, 0);
            // Set up the Ground Plane's material
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, .5f, .5f, .5f), new Colorf(1, .1f, .1f, .1f), 20, 0, 0, 0, .2f, .2f);
            
            // Removed textures for sharing app
            //tex = m_Renderer.m_Scene.m_Materials.LoadTexture("Test-01.bmp");
            //m_Renderer.m_Scene.m_Materials.AddMaterialTexture(mat, tex);
            //tex = m_Renderer.m_Scene.m_Materials.LoadTexture("Test-03.bmp");
            //m_Renderer.m_Scene.m_Materials.AddMaterialTexture(mat, tex);

            m_Renderer.m_Scene.m_Geometry.AddPlane(new Vector3(-1, 0, -1),
                                                    new Vector3(1, 0, -1),
                                                    new Vector3(1, 0, 1), mat);

            // Set up the Box
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 0, 1, 0), new Colorf(1, .5f, .8f, .5f), 2, 0, .9f, 0, .5f, .5f);
            m_Renderer.m_Scene.m_Geometry.AddAABoxes(new Vector3(-2, 1.7f, 2), 1.6f, mat);
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 0, 0, 1), new Colorf(1, .5f, .8f, .5f), 2, 0, 0, 0, .5f, .5f);
            m_Renderer.m_Scene.m_Geometry.AddAABoxes(new Vector3(2, 1.6f, -2), 1.6f, mat);

            // Set up the Sphere
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 0, 0, 0), new Colorf(1, .8f, .8f, .8f), 100, .1f, .5f, .9f, .5f, 1);
            m_Renderer.m_Scene.m_Geometry.AddSpheres(new Vector3(3, 3, 3), 2, mat);
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, .5f, .5f, .5f), new Colorf(1, 0, 0, 0), 10, .7f, 0, 0, .5f, 1);
            m_Renderer.m_Scene.m_Geometry.AddSpheres(new Vector3(.5f, 4, -2), .5f, mat);

            // Make the Triangles Material
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 1, 1, 1), new Colorf(1, .5f, .8f, .5f), 2, .1f, 0, 0, 1, 1);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-3, 0, -6), new Colorf(1, 1, 0, 0), new Vector2(0, 0),
                                                            new Vector3(3, 6, -6), new Colorf(1, 0, 0, 1), new Vector2(1, 1),
                                                            new Vector3(3, 0, -6), new Colorf(1, 0, 1, 0), new Vector2(0, 1), true, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-3, 0, -6), new Colorf(1, 1, 0, 0), new Vector2(0, 0),
                                                            new Vector3(-3, 6, -6), new Colorf(1, 0, 1, 0), new Vector2(1, 0),
                                                            new Vector3(3, 6, -6), new Colorf(1, 0, 0, 1), new Vector2(1, 1), true, mat);
            // Make a Disc
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 1, 0, 1), new Colorf(1, .5f, .8f, .5f), 20, .5f, 0, 0, 1, 1);
            m_Renderer.m_Scene.m_Geometry.AddDiscs(new Vector3(0, -4, -1), new Vector3(0, -4, 1), new Vector3(0, 1, 0), new Vector3(-4, 3, 2), 7, mat);

            // Make an Ellipsoid
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, .5f, .5f, 0), new Colorf(1, .5f, .5f, .1f), 50, 0, 0, 0, 2.5f, 5);
            //tex = m_Renderer.m_Scene.m_Materials.LoadTexture("C:\\Test-02.bmp");
            //m_Renderer.m_Scene.m_Materials.AddMaterialTexture(mat, tex);
            m_Renderer.m_Scene.m_Geometry.AddEllipsoid(new Vector3(-2, 4, -2), 1.5f, .7f, 1f, mat);

            // Make a Cylender
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 1, 0, 0), new Colorf(1, .8f, .5f, .5f), 20, .6f, 0, 0, 2.0f, 2.0f);
            m_Renderer.m_Scene.m_Geometry.AddCylender(new Vector3(-5, 7, -2), new Vector3(3, 4, -5), 1, mat);

            // Set up the Point light
            m_Renderer.m_Scene.m_Lighting.SetAmbient(new Colorf(1, 1, 1, 1), .1f);
            m_Renderer.m_Scene.m_Lighting.AddSpotLight(new Vector3(0, 20, 0), new Vector3(0, -1, 0), new Colorf(1, 1, 1, 1), .1f, .01f, .001f, 10, true);

            // Save the Scene
            //m_Renderer.m_Scene.Save("C:\\TestScene.BSR");
            //m_Renderer.m_Scene.Reset();
            //m_Renderer.m_Scene.Load("C:\\TestScene.BSR");
        }

        private void InitSceneTest()
        {
            int mat = 0;
            int tex = 0;
            // init the Scene
            m_Renderer = new Renderer(this.Width, this.Height);
            // Set up the View
            m_Renderer.SetLookAt(new Vector3(5, -3, 10), new Vector3(0, 0, 0), new Vector3(0, 1, 0));
            // Set the Back Color
            m_Renderer.m_BackColor = new Colorf(1, 0, 0, 0);
            // Set up the Point light 
            m_Renderer.m_Scene.m_Lighting.SetAmbient(new Colorf(1, 1, 1, 1), 1.0f);
            //m_Renderer.m_Scene.m_Lighting.AddSpotLight(new Vector3(0, 0, -20), new Vector3(0, 0, -1), new Colorf(1, 1, 1, 1), .1f, .01f, .001f, 10, true);
            // Set up the Material
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 1, 1, 1), new Colorf(1, .8f, .5f, .5f), 0, .5f, 0, 0, 5, 5);

            // Front
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, 1), new Colorf(1, 1, 0, 0), new Vector2(0, 0),
                                                        new Vector3(1, -1, 1), new Colorf(1, 1, 0, 0), new Vector2(1, 0),
                                                        new Vector3(1, 1, 1), new Colorf(1, 1, 0, 0), new Vector2(1, 1), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, 1), new Colorf(1, 1, 0, 0), new Vector2(0, 0),
                                                        new Vector3(1, 1, 1), new Colorf(1, 1, 0, 0), new Vector2(1, 1),
                                                        new Vector3(-1, 1, 1), new Colorf(1, 1, 0, 0), new Vector2(0, 1), false, mat);
            // Back
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, -1), new Colorf(1, 0, 1, 0), new Vector2(0, 0),
                                                        new Vector3(1, 1, -1), new Colorf(1, 0, 1, 0), new Vector2(1, 1),
                                                        new Vector3(1, -1, -1), new Colorf(1, 0, 1, 0), new Vector2(1, 0), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, -1), new Colorf(1, 0, 1, 0), new Vector2(0, 0),
                                                        new Vector3(-1, 1, -1), new Colorf(1, 0, 1, 0), new Vector2(0, 1),
                                                        new Vector3(1, 1, -1), new Colorf(1, 0, 1, 0), new Vector2(1, 1), false, mat);
            // Left
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, 1), new Colorf(1, 0, 0, 1), new Vector2(0, 0),
                                                        new Vector3(-1, -1, -1), new Colorf(1, 0, 0, 1), new Vector2(1, 1),
                                                        new Vector3(-1, 1, -1), new Colorf(1, 0, 0, 1), new Vector2(1, 0), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, 1), new Colorf(1, 0, 0, 1), new Vector2(0, 0),
                                                        new Vector3(-1, 1, -1), new Colorf(1, 0, 0, 1), new Vector2(0, 1),
                                                        new Vector3(-1, 1, 1), new Colorf(1, 0, 0, 1), new Vector2(1, 1), false, mat);

            // Right
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(1, -1, 1), new Colorf(1, 1, 0, 1), new Vector2(0, 0),
                                                        new Vector3(1, 1, -1), new Colorf(1, 1, 0, 1), new Vector2(1, 0),
                                                        new Vector3(1, -1, -1), new Colorf(1, 1, 0, 1), new Vector2(1, 1), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(1, -1, 1), new Colorf(1, 1, 0, 1), new Vector2(0, 0),
                                                        new Vector3(1, 1, 1), new Colorf(1, 1, 0, 1), new Vector2(1, 1),
                                                        new Vector3(1, 1, -1), new Colorf(1, 1, 0, 1), new Vector2(0, 1), false, mat);

            // Top
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, 1, -1), new Colorf(1, 1, 1, 0), new Vector2(0, 0),
                                                        new Vector3(1, 1, -1), new Colorf(1, 1, 1, 0), new Vector2(1, 0),
                                                        new Vector3(1, 1, 1), new Colorf(1, 1, 1, 0), new Vector2(1, 1), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, 1, -1), new Colorf(1, 1, 1, 0), new Vector2(0, 0),
                                                        new Vector3(1, 1, 1), new Colorf(1, 1, 1, 0), new Vector2(1, 1),
                                                        new Vector3(-1, 1, 1), new Colorf(1, 1, 1, 0), new Vector2(0, 1), false, mat);
            // Bottom
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, -1), new Colorf(1, 0, 1, 1), new Vector2(0, 0),
                                                        new Vector3(1, -1, 1), new Colorf(1, 0, 1, 1), new Vector2(1, 1),
                                                        new Vector3(1, -1, -1), new Colorf(1, 0, 1, 1), new Vector2(1, 0), false, mat);
            m_Renderer.m_Scene.m_Geometry.AddTriangle(new Vector3(-1, -1, -1), new Colorf(1, 0, 1, 1), new Vector2(0, 0),
                                                        new Vector3(-1, -1, 1), new Colorf(1, 0, 1, 1), new Vector2(0, 1),
                                                        new Vector3(1, -1, 1), new Colorf(1, 0, 1, 1), new Vector2(1, 1), false, mat);

            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 1, 0, 0), new Colorf(1, .8f, .5f, .5f), 0, 0, 0, 0, 3, 3);
            m_Renderer.m_Scene.CreateCube(new Vector3(1, 1, -1.5f), new Colorf(1, 1, 1, 1), 2, false, mat);
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 0, 1, 0), new Colorf(1, .8f, .5f, .5f), 0, .5f, 0, 0, 3, 3);
            m_Renderer.m_Scene.CreateCube(new Vector3(-1, 1, 1.5f), new Colorf(1, 1, 1, 1), 2, false, mat);
            mat = m_Renderer.m_Scene.m_Materials.AddMaterial(new Colorf(1, 0, 0, 1), new Colorf(1, .8f, .5f, .5f), 0, .5f, 0, 0, 1, 1);
            m_Renderer.m_Scene.CreateCube(new Vector3(0, 1, 5), new Colorf(1, 1, 1, 1), 2, false, mat);

            //m_Renderer.m_Scene.Save("C:\\PolyScene.BSR");
            //m_Renderer.m_Scene.Reset();
            //m_Renderer.m_Scene.Load("C:\\PolyScene.BSR");

        }

        private void DrawWindow()
        {
            this.Text = "BLSpaceRay Testing Application - Rendering.......";
            Bitmap offScreenBmp;
            Graphics offScreenDC;
            offScreenBmp = m_Renderer.m_Image;
            offScreenDC = Graphics.FromImage(offScreenBmp);
            // render the image and then show it.
            while (!m_Renderer.Render())
            {
                Application.DoEvents();
                if (m_Running)
                {
                    this.CreateGraphics().DrawImage(offScreenBmp, 0, 0, this.Width, this.Height);
                }
            }
            if (m_Running)
            {
                this.BackgroundImage = new Bitmap(offScreenBmp, this.Width, this.Height);
                this.Text = "BLSpaceRay Testing Application";
            }

        }

        private void frmMain_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_Running = false;
        }
    }
}
