﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Scene;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene
{
    public class Scene
    {
        #region " Variables "

        public Geometry.Geometry m_Geometry;
        public Lighting.Lighting m_Lighting;
        public Materials.Material m_Materials;

        #endregion

        #region " Constructors "

        public Scene()
        {
            m_Geometry = new Geometry.Geometry();
            m_Lighting = new Lighting.Lighting();
            m_Materials = new Materials.Material();
        }

        #endregion

        #region " Methods "

        public void Reset()
        {
            // Set New values
            m_Geometry = new Geometry.Geometry();
            m_Lighting = new Lighting.Lighting();
            m_Materials = new Materials.Material();
        }

        public void CreateCube(Vector3 Center, Colorf col, float size,bool facenorm, int Mat)
        {
            Vector3[] Vp = new Vector3[8];
            Vector2[] Vuv = new Vector2[4];
            float s = size / 2;
            // Build the Vertecies
            Vp[0] = new Vector3(-1 * s + Center.X, -1 * s + Center.Y, -1 * s + Center.Z);
            Vp[1] = new Vector3(1 * s + Center.X, -1 * s + Center.Y, -1 * s + Center.Z);
            Vp[2] = new Vector3(1 * s + Center.X, 1 * s + Center.Y, -1 * s + Center.Z);
            Vp[3] = new Vector3(-1 * s + Center.X, 1 * s + Center.Y, -1 * s + Center.Z);

            Vp[4] = new Vector3(-1 * s + Center.X, -1 * s + Center.Y, 1 * s + Center.Z);
            Vp[5] = new Vector3(1 * s + Center.X, -1 * s + Center.Y, 1 * s + Center.Z);
            Vp[6] = new Vector3(1 * s + Center.X, 1 * s + Center.Y, 1 * s + Center.Z);
            Vp[7] = new Vector3(-1 * s + Center.X, 1 * s + Center.Y, 1 * s + Center.Z);

            Vuv[0] = new Vector2(0, 0);
            Vuv[1] = new Vector2(1, 0);
            Vuv[2] = new Vector2(1, 1);
            Vuv[3] = new Vector2(0, 1);

            // Front Faces
            m_Geometry.AddTriangle(Vp[0], col, Vuv[0],
                                    Vp[1], col, Vuv[1],
                                    Vp[2], col, Vuv[2],facenorm, Mat);
            m_Geometry.AddTriangle(Vp[0], col, Vuv[0],
                                    Vp[2], col, Vuv[2],
                                    Vp[3], col, Vuv[3], facenorm, Mat);

            // Back Faces
            m_Geometry.AddTriangle(Vp[5], col, Vuv[0],
                                    Vp[4], col, Vuv[1],
                                    Vp[7], col, Vuv[2], facenorm, Mat);
            m_Geometry.AddTriangle(Vp[5], col, Vuv[0],
                                    Vp[7], col, Vuv[2],
                                    Vp[6], col, Vuv[3], facenorm, Mat);

            // Left Faces
            m_Geometry.AddTriangle(Vp[4], col, Vuv[0],
                                    Vp[0], col, Vuv[1],
                                    Vp[3], col, Vuv[2], facenorm, Mat);
            m_Geometry.AddTriangle(Vp[4], col, Vuv[0],
                                    Vp[3], col, Vuv[2],
                                    Vp[7], col, Vuv[3], facenorm, Mat);

            // Right Faces
            m_Geometry.AddTriangle(Vp[5], col, Vuv[0],
                                    Vp[1], col, Vuv[1],
                                    Vp[2], col, Vuv[2], facenorm, Mat);
            m_Geometry.AddTriangle(Vp[5], col, Vuv[0],
                                    Vp[2], col, Vuv[2],
                                    Vp[6], col, Vuv[3], facenorm, Mat);

            // Top Faces
            m_Geometry.AddTriangle(Vp[3], col, Vuv[0],
                                    Vp[2], col, Vuv[1],
                                    Vp[6], col, Vuv[2], facenorm, Mat);
            m_Geometry.AddTriangle(Vp[3], col, Vuv[0],
                                    Vp[6], col, Vuv[2],
                                    Vp[7], col, Vuv[3], facenorm, Mat);

            // Bottom Faces
            m_Geometry.AddTriangle(Vp[4], col, Vuv[0],
                                    Vp[5], col, Vuv[1],
                                    Vp[1], col, Vuv[2], facenorm, Mat);
            m_Geometry.AddTriangle(Vp[4], col, Vuv[0],
                                    Vp[1], col, Vuv[2],
                                    Vp[0], col, Vuv[3], facenorm, Mat);
        }

        #endregion

        #region " Save / Load "

        public bool Save(string Filename)
        {
            Colorf col = new Colorf();
            FileStream fs = new FileStream
                (
                Filename,
                FileMode.Create,
                FileAccess.Write,
                FileShare.None
                );

            BinaryWriter bw = new BinaryWriter(fs);

            // Save the Geometry
            bw.Write(m_Geometry.m_NumObjects);
            for (int X = 0; X < m_Geometry.m_NumObjects; X++)
            {
                // Save the type of Geomerty
                bw.Write(m_Geometry.m_Objects[X].GetKind());

                switch (m_Geometry.m_Objects[X].GetKind())
                {
                    case 0:     // Plane
                        // Save the Normal
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Normal.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Normal.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Normal.Z);
                        // Save hte point on plane
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Point.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Point.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Point.Z);
                        // Save the Distance to oragin
                        bw.Write(m_Geometry.m_Objects[X].m_Plane.m_Distance);
                        break;
                    case 1:     // Sphere
                        // Save the Center
                        bw.Write(m_Geometry.m_Objects[X].m_Sphere.m_Center.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Sphere.m_Center.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Sphere.m_Center.Z);
                        // Save the Radius
                        bw.Write(m_Geometry.m_Objects[X].m_Sphere.m_Radius);
                        break;
                    case 2:     // AABox
                        // Save the Min
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Min.X);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Min.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Min.Z);
                        // Save the Max
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Max.X);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Max.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Max.Z);
                        // Save the Center
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Center.X);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Center.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_AABox.m_Center.Z);
                        break;
                    case 3:     // Triangle
                        // Save the 3 Vertex Indices
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Vert1);
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Vert2);
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Vert3);
                        // Save the normal option
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_FaceNormal);
                        // Save the normal
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Normal.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Normal.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Triangle.m_Normal.Z);
                        break;
                    case 4:     // Disc
                        // Save the Plane Normal
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Normal.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Normal.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Normal.Z);
                        // Save hte point on plane
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Point.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Point.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Point.Z);
                        // Save the plane Distance to oragin
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Plane.m_Distance);
                        // Save the center of the disc
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Center.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Center.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Center.Z);
                        // Save the Radius
                        bw.Write(m_Geometry.m_Objects[X].m_Disc.m_Radius);
                        break;
                    case 5:     // Ellipsoid
                        // Save the Center
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_Center.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_Center.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_Center.Z);
                        // Save the Radius
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_Radius);
                        // Save the XY ratio
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_YRatio);
                        // Save the XZ ratio
                        bw.Write(m_Geometry.m_Objects[X].m_Ellipsoid.m_ZRatio);
                        break;
                    case 6:     // Cylinder
                        // Save the Start position
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_Start.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_Start.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_Start.Z);
                        // Save the end position
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_End.X);
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_End.Y);
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_End.Z);
                        //Save the radius
                        bw.Write(m_Geometry.m_Objects[X].m_Cylinder.m_Radius);
                        break;
                    case 7:     // Torus
                        // Not implemented yet
                        break;
                }
                // Save the Material Index
                bw.Write(m_Geometry.m_Objects[X].m_Material);
            }

            // Save the Vertices
            bw.Write(m_Geometry.m_NumVerts);
            for (int X = 0; X < m_Geometry.m_NumVerts; X++)
            {
                // Save the position
                bw.Write(m_Geometry.m_Verts[X].m_Position.X);
                bw.Write(m_Geometry.m_Verts[X].m_Position.Y);
                bw.Write(m_Geometry.m_Verts[X].m_Position.Z);
                // Save the normal
                bw.Write(m_Geometry.m_Verts[X].m_Normal.X);
                bw.Write(m_Geometry.m_Verts[X].m_Normal.Y);
                bw.Write(m_Geometry.m_Verts[X].m_Normal.Z);
                // Save the color
                bw.Write(m_Geometry.m_Verts[X].m_Color.A);
                bw.Write(m_Geometry.m_Verts[X].m_Color.R);
                bw.Write(m_Geometry.m_Verts[X].m_Color.G);
                bw.Write(m_Geometry.m_Verts[X].m_Color.B);
                // Save the texture UV
                bw.Write(m_Geometry.m_Verts[X].m_UV.X);
                bw.Write(m_Geometry.m_Verts[X].m_UV.Y);
            }

            // Save the Surface Settings
            bw.Write(m_Materials.m_NumSurfaces);
            for (int X = 0; X < m_Materials.m_NumSurfaces; X++)
            {
                // Save the diffuse color
                bw.Write(m_Materials.m_Surfaces[X].m_Diffuse.A);
                bw.Write(m_Materials.m_Surfaces[X].m_Diffuse.R);
                bw.Write(m_Materials.m_Surfaces[X].m_Diffuse.G);
                bw.Write(m_Materials.m_Surfaces[X].m_Diffuse.B);
                // Save the specular color
                bw.Write(m_Materials.m_Surfaces[X].m_Specular.A);
                bw.Write(m_Materials.m_Surfaces[X].m_Specular.R);
                bw.Write(m_Materials.m_Surfaces[X].m_Specular.G);
                bw.Write(m_Materials.m_Surfaces[X].m_Specular.B);
                // Save the specular Power
                bw.Write(m_Materials.m_Surfaces[X].m_SpecularPOW);
                // Save the Reflective value
                bw.Write(m_Materials.m_Surfaces[X].m_Reflective);
                // Save the Transparent value
                bw.Write(m_Materials.m_Surfaces[X].m_Transparent);
                // Save the Diffraction value
                bw.Write(m_Materials.m_Surfaces[X].m_Diffraction);
                // Save the UV Scales
                bw.Write(m_Materials.m_Surfaces[X].m_UScale);
                bw.Write(m_Materials.m_Surfaces[X].m_VScale);
                // Save the Texture indexs
                bw.Write(m_Materials.m_Surfaces[X].m_Textured);
                bw.Write(m_Materials.m_Surfaces[X].m_NumTextures);
                for (int Y = 0; Y < m_Materials.m_Surfaces[X].m_NumTextures; Y++)
                {
                    bw.Write(m_Materials.m_Surfaces[X].m_Textures[Y]);
                }
            }

            // Save the Texture Data
            bw.Write(m_Materials.m_NumTextures);
            for (int A = 0; A < m_Materials.m_NumTextures; A++)
            {
                // Save the Dimentions
                bw.Write(m_Materials.m_Textures[A].m_Image.Width);
                bw.Write(m_Materials.m_Textures[A].m_Image.Height);
                for (int Y = 0; Y < m_Materials.m_Textures[A].m_Image.Height; Y++)
                {
                    for (int X = 0; X < m_Materials.m_Textures[A].m_Image.Width; X++)
                    {
                        // Get the Color at the X Y
                        col = new Colorf(m_Materials.m_Textures[A].m_Image.GetPixel(X, Y));
                        // Save the Color
                        bw.Write(col.A);
                        bw.Write(col.R);
                        bw.Write(col.G);
                        bw.Write(col.B);
                    }
                }
            }

            // Save the ambient lighting vlaues
            bw.Write(m_Lighting.m_Ambient.A);
            bw.Write(m_Lighting.m_Ambient.R);
            bw.Write(m_Lighting.m_Ambient.G);
            bw.Write(m_Lighting.m_Ambient.B);
            bw.Write(m_Lighting.m_AmbientIntensity);
            // Save the number of lights
            bw.Write(m_Lighting.m_NumLights);
            // Save each light
            for (int X = 0; X < m_Lighting.m_NumLights; X++)
            {
                // Save the Kinda of light
                bw.Write(m_Lighting.m_Lights[X].GetKind());

                switch (m_Lighting.m_Lights[X].GetKind())
                {
                    case 0:     // Direction
                        // Save the Direction
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.X);
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.Y);
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.Z);
                        // Save the Light Color
                        bw.Write(m_Lighting.m_Lights[X].m_Color.A);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.R);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.G);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.B);
                        // Save the Shadowed flag
                        bw.Write(m_Lighting.m_Lights[X].m_Shadowed);
                        // Save the Intensity
                        bw.Write(m_Lighting.m_Lights[X].m_Constant);
                        break;
                    case 1:     // Point
                        // Save the Position
                        bw.Write(m_Lighting.m_Lights[X].m_Position.X);
                        bw.Write(m_Lighting.m_Lights[X].m_Position.Y);
                        bw.Write(m_Lighting.m_Lights[X].m_Position.Z);
                        // Save the Light Color
                        bw.Write(m_Lighting.m_Lights[X].m_Color.A);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.R);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.G);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.B);
                        // Save the Shadowed flag
                        bw.Write(m_Lighting.m_Lights[X].m_Shadowed);
                        // Save the Constant
                        bw.Write(m_Lighting.m_Lights[X].m_Constant);
                        // Save the Linear
                        bw.Write(m_Lighting.m_Lights[X].m_Linear);
                        // Save the Quadratic
                        bw.Write(m_Lighting.m_Lights[X].m_Quadratic);
                        break;
                    case 2:     // Spot
                        // Save the Direction
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.X);
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.Y);
                        bw.Write(m_Lighting.m_Lights[X].m_Direction.Z);
                        // Save the Position
                        bw.Write(m_Lighting.m_Lights[X].m_Position.X);
                        bw.Write(m_Lighting.m_Lights[X].m_Position.Y);
                        bw.Write(m_Lighting.m_Lights[X].m_Position.Z);
                        // Save the Light Color
                        bw.Write(m_Lighting.m_Lights[X].m_Color.A);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.R);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.G);
                        bw.Write(m_Lighting.m_Lights[X].m_Color.B);
                        // Save the Shadowed flag
                        bw.Write(m_Lighting.m_Lights[X].m_Shadowed);
                        // Save the Constant
                        bw.Write(m_Lighting.m_Lights[X].m_Constant);
                        // Save the Linear
                        bw.Write(m_Lighting.m_Lights[X].m_Linear);
                        // Save the Quadratic
                        bw.Write(m_Lighting.m_Lights[X].m_Quadratic);
                        // Save the Power
                        bw.Write(m_Lighting.m_Lights[X].m_POW);
                        break;
                }
            }

            // Close the files
            bw.Close();
            fs.Close();
            return true;
        }

        public bool Load(string Filename)
        {
            // Variables to pull out of file
            bool opt;
            int A = 0; int R = 0; int G = 0; int B = 0;
            int I1 = 0; int I2 = 0; int I3 = 0;
            float x = 0; float y = 0; float z = 0; float d = 0; float r = 0;
            float a = 0; float g = 0; float b = 0;
            Vector3 vec1, vec2, vec3;
            Colorf col1, col2;

            FileStream fs = new FileStream
                (
                Filename,
                FileMode.Open,
                FileAccess.Read,
                FileShare.None
                );

            BinaryReader br = new BinaryReader(fs);

            // Find out how many objects are seaved
            A = br.ReadInt32();
            // Make room for the number of objects
            m_Geometry.m_Objects = new BLSpaceRay.Scene.Geometry.Primitive[A+10];
            m_Geometry.m_NumObjects = A;
            for (int Q = 0; Q < A; Q++)
            {
                // Get the type of object
                R = br.ReadInt32();
                switch (R)
                {
                    case 0:     // Plane
                        // Get the Normal floats
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the point on plane
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec2 = new Vector3(x, y, z);
                        // get the Distance to orgin
                        d = br.ReadSingle();
                        // get the mat index
                        G = br.ReadInt32();
                        // Make the Plane
                        m_Geometry.m_Objects[Q] = new Geometry.GeoPlane(vec1, vec2, d, G);
                        break;
                    case 1:     // Sphere
                        // Get the Center
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the radius
                        d = br.ReadSingle();
                        // get the mat index
                        G = br.ReadInt32();
                        // Make the Sphere
                        m_Geometry.m_Objects[Q] = new Geometry.GeoSphere(vec1, d, G);
                        break;
                    case 2:     // AABox
                        // Get the Min
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the Max
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec2 = new Vector3(x, y, z);
                        // Get the Center
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec3 = new Vector3(x, y, z);
                        // get the mat index
                        G = br.ReadInt32();
                        // Make the AABox
                        m_Geometry.m_Objects[Q] = new Geometry.GeoAABox(vec1, vec2, G);
                        break;
                    case 3:     // Triangle
                        // get the 3 vert indices
                        I1 = br.ReadInt32();
                        I2 = br.ReadInt32();
                        I3 = br.ReadInt32();
                        // get the normal option
                        opt = br.ReadBoolean();
                        // get the normal
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // get the mat index
                        G = br.ReadInt32();
                        // Make the Triangle
                        m_Geometry.m_Objects[Q] = new Geometry.GeoTriangle(I1, I2, I3, opt, vec1, G);
                        break;
                    case 4:     // Disc
                        // Get the Normal floats
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the point on plane
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec2 = new Vector3(x, y, z);
                        // get the Distance to orgin
                        d = br.ReadSingle();
                        // Get the Center of the radius
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec3 = new Vector3(x, y, z);
                        // get the radius
                        r = br.ReadSingle();
                        // get the material index
                        G = br.ReadInt32();
                        // Make the Disc
                        m_Geometry.m_Objects[Q] = new Geometry.GeoDisc(vec1, vec2, d, vec3, r, G);
                        break;
                    case 5:     // Ellipsoid
                        // Get the Normal floats
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the radius
                        x = br.ReadSingle();
                        // Get the XY ratio
                        y = br.ReadSingle();
                        // Get the XZ ratio
                        z = br.ReadSingle();
                        // get the material index
                        G = br.ReadInt32();
                        // Make the Ellipsoid
                        m_Geometry.m_Objects[Q] = new Geometry.GeoEllipsoid(vec1, x, y, z, G);
                        break;
                    case 6:     // Cylinder
                        // Get the Start
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the End
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec2 = new Vector3(x, y, z);
                        // get the radius
                        x = br.ReadSingle();
                        // get the material index
                        G = br.ReadInt32();
                        // Make the Cylinder
                        m_Geometry.m_Objects[Q] = new Geometry.GeoCylinder(vec1, vec2, x, G);
                        break;
                    case 7:     // Torus
                        // Not implemented yet
                        break;
                }
            }

            // Get the total Vertices
            A = br.ReadInt32();
            m_Geometry.m_Verts = new Vertex[A + 10];
            m_Geometry.m_NumVerts = A;
            for (int X = 0; X < A; X++)
            {
                // Get the Position
                x = br.ReadSingle();
                y = br.ReadSingle();
                z = br.ReadSingle();
                vec1 = new Vector3(x, y, z);
                // Get the Normal
                x = br.ReadSingle();
                y = br.ReadSingle();
                z = br.ReadSingle();
                vec2 = new Vector3(x, y, z);
                // Get the color
                a = br.ReadSingle();
                r = br.ReadSingle();
                g = br.ReadSingle();
                b = br.ReadSingle();
                col1 = new Colorf(a, r, g, b);
                // Save the texture UV
                x = br.ReadSingle();
                y = br.ReadSingle();
                m_Geometry.m_Verts[X] = new Vertex(vec1, vec2, col1, new Vector2(x, y));
            }

            // Get the Total Surface
            A = br.ReadInt32();
            m_Materials.m_Surfaces = new BLSpaceRay.Scene.Materials.Surface[A + 10];
            m_Materials.m_NumSurfaces = A;
            for (int X = 0; X < m_Materials.m_NumSurfaces; X++)
            {
                // Get the diffuse color
                a = br.ReadSingle();
                r = br.ReadSingle();
                g = br.ReadSingle();
                b = br.ReadSingle();
                col1 = new Colorf(a, r, g, b);
                // Get the specular color
                a = br.ReadSingle();
                r = br.ReadSingle();
                g = br.ReadSingle();
                b = br.ReadSingle();
                col2 = new Colorf(a, r, g, b);
                // Get the specular Power
                a = br.ReadSingle();
                // Getthe Reflective value
                r = br.ReadSingle();
                // Get the Transparent value
                g = br.ReadSingle();
                // Get the Diffraction value
                b = br.ReadSingle();
                // Get the UV Scales
                x = br.ReadSingle();
                y = br.ReadSingle();
                // get the Texture option
                opt = br.ReadBoolean();
                B = br.ReadInt32();
                // Make the Surface
                m_Materials.m_Surfaces[X] = new BLSpaceRay.Scene.Materials.Surface(col1, col2, a, r, g, b, x, y);
                for (int Y = 0; Y < B; Y++)
                {
                    G = br.ReadInt32();
                    m_Materials.m_Surfaces[X].AddTexture(G);
                }
            }

            // Get the Texture Data
            A = br.ReadInt32();
            m_Materials.m_Textures = new BLSpaceRay.Scene.Materials.Texture[A + 10];
            m_Materials.m_NumTextures = A;
            for (int I = 0; I < A; I++)
            {
                // Get the Dimentions
                I1 = br.ReadInt32();
                I2 = br.ReadInt32();
                m_Materials.m_Textures[I] = new BLSpaceRay.Scene.Materials.Texture(I1, I2);
                for (int Y = 0; Y < m_Materials.m_Textures[I].m_Image.Height; Y++)
                {
                    for (int X = 0; X < m_Materials.m_Textures[I].m_Image.Width; X++)
                    {
                        // Get the Color
                        a = br.ReadSingle();
                        r = br.ReadSingle();
                        g = br.ReadSingle();
                        b = br.ReadSingle();
                        col1 = new Colorf(a, r, g, b);
                        // Set the Color at the X Y
                        m_Materials.m_Textures[I].m_Image.SetPixel(X, Y, col1.ToSystemColor());
                    }
                }
            }

            // Get the ambient lighting vlaues
            a = br.ReadSingle();
            r = br.ReadSingle();
            g = br.ReadSingle();
            b = br.ReadSingle();
            col1 = new Colorf(a, r, g, b);
            a = br.ReadSingle();
            m_Lighting.SetAmbient(col1, a);
            // Get the total Number of lights
            A = br.ReadInt32();
            m_Lighting.m_Lights = new BLSpaceRay.Scene.Lighting.Light[A + 10];         
            m_Lighting.m_NumLights = A;
            // Save each light
            for (int X = 0; X < A; X++)
            {
                // Get the Kinda of light
                R = br.ReadInt32();

                switch (R)
                {
                    case 0:     // Direction
                        // get the Direction
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x,y,z);
                        // Get the Light Color
                        a = br.ReadSingle();
                        r = br.ReadSingle();
                        g = br.ReadSingle();
                        b = br.ReadSingle();
                        col1 = new Colorf(a, r, g, b);
                        // Get the Shadowed flag
                        opt = br.ReadBoolean();
                        // Get the Intensity
                        x = br.ReadSingle();
                        // Make the Light
                        m_Lighting.m_Lights[X] = new Lighting.LightDirection(vec1, col1, x, opt);
                        break;
                    case 1:     // Point
                        // get the Position
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // Get the Light Color
                        a = br.ReadSingle();
                        r = br.ReadSingle();
                        g = br.ReadSingle();
                        b = br.ReadSingle();
                        col1 = new Colorf(a, r, g, b);
                        // Get the Shadowed flag
                        opt = br.ReadBoolean();
                        // Get the Constant
                        x = br.ReadSingle();
                        // Get the Linear
                        y = br.ReadSingle();
                        // Get the Quadratic
                        z = br.ReadSingle();
                        // Make the Light
                        m_Lighting.m_Lights[X] = new Lighting.LightPoint(vec1, col1, x, y, z, opt);
                        break;
                    case 2:     // Spot
                        // get the Direction
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec1 = new Vector3(x, y, z);
                        // get the Position
                        x = br.ReadSingle();
                        y = br.ReadSingle();
                        z = br.ReadSingle();
                        vec2 = new Vector3(x, y, z);
                        // Get the Light Color
                        a = br.ReadSingle();
                        r = br.ReadSingle();
                        g = br.ReadSingle();
                        b = br.ReadSingle();
                        col1 = new Colorf(a, r, g, b);
                        // Get the Shadowed flag
                        opt = br.ReadBoolean();
                        // Get the Constant
                        x = br.ReadSingle();
                        // Get the Linear
                        y = br.ReadSingle();
                        // Get the Quadratic
                        z = br.ReadSingle();
                        // Get the Pow
                        a = br.ReadSingle();
                        // Make the Light
                        m_Lighting.m_Lights[X] = new Lighting.LightSpot(vec2,vec1, col1, x, y, z,a, opt);
                        break;
                }
            }

            // Close the files
            br.Close();
            fs.Close();
            return true;
        }

        #endregion
    }
}
