﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Materials
{
    public class Texture
    {
        #region " Variables "

        public Bitmap m_Image;

        #endregion

        #region " Constructors "

        public Texture(int width, int height)
        {
            m_Image = new Bitmap(width, height);
        }

        public Texture(string Filename)
        {
            m_Image = new Bitmap(Filename);
        }

        #endregion

        #region " Methods "

        public void Set(string Filename)
        {
            m_Image = new Bitmap(Filename);
        }

        public Colorf GetTexel(float U, float V)
        {
            // Make the UV between 0 and 1
            if (U < 0)
                U = -U;
            //while (U > 200000)
            //    U -= 100000;
            //while (U > 1)
            //    U -= 1;
            if (V < 0)
                V = -V;
            //while (V > 200000)
            //    V -= 100000;
            //while (V > 1)
            //    V -= 1;

            if (float.IsNaN(V))
                V = 0;
            if (float.IsNaN(U))
                U = 0;

            // Bilinearly filtering
            float fu = (U + 1000.5f) * m_Image.Width;
            float fv = (V + 1000.0f) * m_Image.Width;
            int u1 = ((int)fu) % m_Image.Width;
            int v1 = ((int)fv) % m_Image.Height;
            int u2 = (u1 + 1) % m_Image.Width;
            int v2 = (v1 + 1) % m_Image.Height;
            // calculate fractional parts of u and v
            float fracu = fu - (float)System.Math.Floor(fu);
            float fracv = fv - (float)System.Math.Floor(fv);
            // calculate weight factors
            float w1 = (1 - fracu) * (1 - fracv);
            float w2 = fracu * (1 - fracv);
            float w3 = (1 - fracu) * fracv;
            float w4 = fracu * fracv;
            // fetch four texels
            Colorf c1 = new Colorf(m_Image.GetPixel(u1, v1));
            Colorf c2 = new Colorf(m_Image.GetPixel(u2, v1));
            Colorf c3 = new Colorf(m_Image.GetPixel(u1, v2));
            Colorf c4 = new Colorf(m_Image.GetPixel(u2, v2));
            // scale and sum the four colors
            return c1 * w1 + c2 * w2 + c3 * w3 + c4 * w4;
        }

        #endregion
    }
}
