﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Materials
{
    public class Surface
    {
        #region " Variables "

        public Colorf m_Diffuse;
        public Colorf m_Specular;
        public float m_SpecularPOW;

        public bool m_Textured;
        public int[] m_Textures;
        public int m_NumTextures;

        public float m_Reflective;
        public float m_Transparent;
        public float m_Diffraction;

        public float m_UScale;
        public float m_VScale;

        #endregion

        #region " Constructors "

        public Surface()
        {
            // Set the default values
            m_Diffuse = new Colorf(1, 1, 1, 1);
            m_Specular = new Colorf(1, 1, 1, 1);
            m_SpecularPOW = 20;

            m_Textured = false;
            m_Textures = null;
            m_NumTextures = 0;

            m_Reflective = 0.0f;
            m_Transparent = 0.0f;
            m_Diffraction = 0.0f;

            m_UScale = 1.0f;
            m_VScale = 1.0f;
        }

        public Surface(Colorf dif, Colorf spec, float specpow, float reflect, float trans, float diffract, float uscale, float vscale)
        {
            // Set the new values
            m_Diffuse = dif;
            m_Specular = spec;
            m_SpecularPOW = specpow;

            m_Textured = false;
            m_Textures = null;
            m_NumTextures = 0;

            m_Reflective = reflect;
            m_Transparent = trans;
            m_Diffraction = diffract;

            m_UScale = uscale;
            m_VScale = vscale;
        }

        #endregion

        #region " Methods "

        public void Set(Colorf dif, Colorf spec, float specpow, float reflect, float trans, float diffract, float uscale, float vscale)
        {
            // Set the new values
            m_Diffuse = dif;
            m_Specular = spec;
            m_SpecularPOW = specpow;

            m_Textured = false;
            m_Textures = null;
            m_NumTextures = 0;

            m_Reflective = reflect;
            m_Transparent = trans;
            m_Diffraction = diffract;

            m_UScale = uscale;
            m_VScale = vscale;
        }

        public int AddTexture(int texture)
        {
            // allocate 10 new memory slots for textures if necessary
            if (m_NumTextures == 0)
            {
                // Size the array for the first 10
                m_Textures = new int[10];
            }
            else if ((m_NumTextures % 10) == 0)
            {
                //Copy The Old Array With one Blank
                int[] Old = new int[m_NumTextures];
                System.Array.Copy(m_Textures, Old, m_NumTextures);

                m_Textures = new int[m_NumTextures + 10];
                System.Array.Copy(Old, m_Textures, m_NumTextures);
            }

            // Set up the new Light
            m_Textures[m_NumTextures] = texture;
            m_NumTextures++;
            // Set the Textured Flag
            m_Textured = true;
            return m_NumTextures - 1;
        }

        #endregion
    }
}
