﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Materials
{
    public class Material
    {
        #region " Variables "

        public Surface[] m_Surfaces;
        public int m_NumSurfaces;

        public Texture[] m_Textures;
        public int m_NumTextures;

        #endregion

        #region " Constructors "

        public Material()
        {
            // Set up the default values
            m_Surfaces = new Surface[10];
            m_NumSurfaces = 0;
            m_Textures = new Texture[10];
            m_NumTextures = 0;

        }

        #endregion

        #region " Mathods "

        public int AddMaterial(Colorf dif, Colorf spec, float specpow, float reflect, float trans, float diffract, float uscale, float vscale)
        {
            // allocate 10 new memory slots for textures if necessary
            if ((m_NumSurfaces % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Surface[] Old = new Surface[m_NumSurfaces];
                System.Array.Copy(m_Surfaces, Old, m_NumSurfaces);

                m_Surfaces = new Surface[m_NumSurfaces + 10];
                System.Array.Copy(Old, m_Surfaces, m_NumSurfaces);
            }
            //Set the New Surface
            m_Surfaces[m_NumSurfaces] = new Surface(dif, spec, specpow, reflect, trans, diffract, uscale, vscale);
            m_NumSurfaces++;
            return m_NumSurfaces - 1;
        }

        public void UpdateMaterial(int I, Colorf dif, Colorf spec, float specpow, float reflect, float trans, float diffract, float uscale, float vscale)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumSurfaces)
                I = m_NumSurfaces;
            // now update the Surface
            m_Surfaces[I] = new Surface(dif, spec, specpow, reflect, trans, diffract, uscale, vscale);
        }

        public void AddMaterialTexture(int I, int text)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumSurfaces)
                I = m_NumSurfaces;
            // now Add the Texture to the Surface
            m_Surfaces[I].AddTexture (text);
        }

        public int LoadTexture(string Filename)
        {
            // allocate 10 new memory slots for textures if necessary
            if ((m_NumTextures % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Texture[] Old = new Texture[m_NumTextures];
                System.Array.Copy(m_Textures, Old, m_NumTextures);

                m_Textures = new Texture[m_NumTextures + 10];
                System.Array.Copy(Old, m_Textures, m_NumTextures);
            }
            //Set the New Surface
            m_Textures[m_NumTextures] = new Texture(Filename);
            m_NumTextures++;
            return m_NumTextures - 1;
        }

        public void ChangeTexture(int I, string Filename)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumSurfaces)
                I = m_NumSurfaces;
            // Load the new Texture
            m_Textures[I].Set(Filename);
        }

        #endregion
    }
}
