﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Lighting
{
    public class Lighting
    {
        #region " Variables "

        public Colorf m_Ambient;
        public float m_AmbientIntensity;

        public Light[] m_Lights;
        public int m_NumLights;

        #endregion

        #region " Constructors "

        public Lighting()
        {
            // Set the default values
            m_Ambient = new Colorf(1, 1, 1, 1);
            m_AmbientIntensity = 1.0f;

            m_NumLights = 0;

            m_Lights = null;
        }

        #endregion

        #region " Methods "

        public void SetAmbient(Colorf col, float Intensity)
        {
	        // Set the new ambient attriutes
	        m_Ambient = col;
	        m_AmbientIntensity = Intensity;
        }

        public int AddPointLight(Vector3 pos, Colorf col, float cons, float line, float quad, bool shadowed)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if (m_NumLights == 0)
            {
                // Size the array for the first 10
                m_Lights = new Light[10];
            }
            else if ((m_NumLights % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Light[] Old = new Light[m_NumLights];
                System.Array.Copy(m_Lights, Old, m_NumLights);

                m_Lights = new Light[m_NumLights + 10];
                System.Array.Copy(Old, m_Lights, m_NumLights);
            }

            // Set up the new Light
            m_Lights[m_NumLights] = new LightPoint(pos, col, cons, line, quad, shadowed);
            m_NumLights++;
            return m_NumLights - 1;
        }

        public void UpdatePointLight(int I, Vector3 pos, Colorf col, float cons, float line, float quad, bool shadowed)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumLights)
                I = m_NumLights;
            // now update the light
            m_Lights[I] = new LightPoint(pos, col, cons, line, quad, shadowed);
        }

        public int AddDirectionLight(Vector3 dir, Colorf col, float intensity, bool shadowed)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if (m_NumLights == 0)
            {
                // Size the array for the first 10
                m_Lights = new Light[10];
            }
            else if ((m_NumLights % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Light[] Old = new Light[m_NumLights];
                System.Array.Copy(m_Lights, Old, m_NumLights);

                m_Lights = new Light[m_NumLights + 10];
                System.Array.Copy(Old, m_Lights, m_NumLights);
            }

            // Set up the new Light
            m_Lights[m_NumLights] = new LightDirection(dir, col, intensity, shadowed);
            m_NumLights++;
            return m_NumLights - 1;
        }

        public void UpdateDirectionLight(int I, Vector3 dir, Colorf col, float intensity, bool shadowed)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumLights)
                I = m_NumLights;
            // now update the light
            m_Lights[I] = new LightDirection(dir, col, intensity, shadowed);
        }

        public int AddSpotLight(Vector3 pos, Vector3 dir, Colorf col, float cons, float line, float quad, float pow, bool shadowed)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if (m_NumLights == 0)
            {
                // Size the array for the first 10
                m_Lights = new Light[10];
            }
            else if ((m_NumLights % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Light[] Old = new Light[m_NumLights];
                System.Array.Copy(m_Lights, Old, m_NumLights);

                m_Lights = new Light[m_NumLights + 10];
                System.Array.Copy(Old, m_Lights, m_NumLights);
            }

            // Set up the new Light
            m_Lights[m_NumLights] = new LightSpot(pos, dir, col, cons, line, quad, pow, shadowed);
            m_NumLights++;
            return m_NumLights - 1;
        }

        public void UpdateSpotLight(int I, Vector3 pos, Vector3 dir, Colorf col, float cons, float line, float quad, float pow, bool shadowed)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumLights)
                I = m_NumLights;
            // now update the light
            m_Lights[I] = new LightSpot(pos, dir, col, cons, line, quad, pow, shadowed);
        }

        #endregion
    }
}
