﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class Triangle
    {
        public int m_Vert1;
        public int m_Vert2;
        public int m_Vert3;
        public bool m_FaceNormal;
        public Vector3 m_Normal;
    }

    public abstract class Primitive
    {
        public Plane m_Plane;
        public Sphere m_Sphere;
        public AABox m_AABox;
        public Triangle m_Triangle;
        public Disc m_Disc;
        public Ellipsoid m_Ellipsoid;
        public Cylinder m_Cylinder;
        public Torus m_Torus;

        public int m_Material;

        public Primitive()
        {
            m_Plane = null;
            m_Sphere = null;
            m_AABox = null;
            m_Triangle = null;
            m_Disc = null;
            m_Ellipsoid = null;
            m_Cylinder = null;
            m_Torus = null;
            m_Material = -1;
        }

        abstract public int GetKind();
        abstract public Vector3 GetNormal(Vector3 pos);
        abstract public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v);
    }
}
