﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class Geometry
    {
        #region " Variables "

        public Primitive[] m_Objects;
        public int m_NumObjects;

        public Vertex[] m_Verts;
        public int m_NumVerts;

        #endregion

        #region " Constructors "

        public Geometry()
        {
            // Set up the arrays
            m_Objects = new Primitive[0];
            m_NumObjects = 0;
            m_Verts = new Vertex[0];
            m_NumVerts = 0;
        }

        #endregion

        #region " Planes "

        public int AddPlane(Vector3 v0, Vector3 v1, Vector3 v2, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoPlane(v0, v1, v2, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public void UpdatePlane(int I, Vector3 v0, Vector3 v1, Vector3 v2, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[I] = new GeoPlane(v0, v1, v2, mat);
        }

        #endregion

        #region " Spheres "

        public int AddSpheres(Sphere sphere, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoSphere(sphere, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public int AddSpheres(Vector3 center, float radius, int mat)
        {
            return AddSpheres(new Sphere(center, radius), mat);
        }
        public void UpdateSpheres(int I, Sphere sphere, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[I] = new GeoSphere(sphere, mat);
        }
        public void UpdateSpheres(int I, Vector3 center, float radius, int mat)
        {
            UpdateSpheres(I, new Sphere(center, radius), mat);
        }

        #endregion

        #region " AABoxes "

        public int AddAABoxes(Vector3 min, Vector3 max, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new AABox
            m_Objects[m_NumObjects] = new GeoAABox(min, max, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public int AddAABoxes(Vector3 center, float size, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }
            // Set up the new AABox
            m_Objects[m_NumObjects] = new GeoAABox(center - size, center + size, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public void UpdateAABoxes(int I, Vector3 min, Vector3 max, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the AABox
            m_Objects[I] = new GeoAABox(min, max, mat);
        }

        #endregion

        #region " Discs "

        public int AddDiscs(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoDisc(v1, v2, v3, center, radius, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public void UpdateDiscs(int I, Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[I] = new GeoDisc(v1, v2, v3, center, radius, mat);
        }

        #endregion

        #region " Ellipsoid "

        public int AddEllipsoid(Vector3 center, float radius, float yratio, float zratio, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoEllipsoid(center, radius, yratio, zratio, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public void UpdateEllipsoid(int I, Vector3 center, float radius, float yratio, float zratio, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[I] = new GeoEllipsoid(center, radius, yratio, zratio, mat);
        }

        #endregion

        #region " Cylender "

        public int AddCylender(Vector3 start, Vector3 end, float radius, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoCylinder(start, end, radius, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }
        public void UpdateCylender(int I, Vector3 start, Vector3 end, float radius, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[I] = new GeoCylinder(start, end, radius, mat);
        }

        #endregion

        #region " Torus "

        public int AddTorus(Vector3 center, float radius1, float radius2, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }

            // Set up the new Light
            m_Objects[m_NumObjects] = new GeoTorus(center, radius1, radius2, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }

        public void UpdateTorus(int I, Vector3 center, float radius1, float radius2, int mat)
        {
            // make sure the Index is valid
            if (I < 0)
                I = 0;
            if (I > m_NumObjects)
                I = m_NumObjects;
            // now update the Plane
            m_Objects[m_NumObjects] = new GeoTorus(center, radius1, radius2, mat);
        }

        #endregion

        #region " Tirangles "

        public int AddTriangle(Vector3 pos1, Colorf col1, Vector2 UV1,
                                Vector3 pos2,Colorf col2, Vector2 UV2,
                                Vector3 pos3,Colorf col3, Vector2 UV3, bool facenormal, int mat)
        {
            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumObjects % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Primitive[] Old = new Primitive[m_NumObjects];
                System.Array.Copy(m_Objects, Old, m_NumObjects);

                m_Objects = new Primitive[m_NumObjects + 10];
                System.Array.Copy(Old, m_Objects, m_NumObjects);
            }
            // Calculate The Triangles Normal
            Vector3 Normal = new Vector3();
            Vector3 V1;
            Vector3 V2;
            V1 = pos2 - pos1;
            V2 = pos1 - pos3;
            
            Normal = V1.Cross(V2);

            // Add the vertecies
            int v1 = AddVertex(pos1, Normal, col1, UV1);
            int v2 = AddVertex(pos2, Normal, col2, UV2);
            int v3 = AddVertex(pos3, Normal, col3, UV3);

            // Set up the new Triangle
            m_Objects[m_NumObjects] = new GeoTriangle(v1, v2, v3, facenormal, Normal, mat);
            m_NumObjects++;
            return m_NumObjects - 1;
        }

        #endregion

        #region " Vertecies "

        private int AddVertex(Vector3 pos, Vector3 norm, Colorf col, Vector2 UV)
        {
            Vertex V = new Vertex(pos,norm, col, UV);
            // Look for duplicates
            for (int I = 0; I < m_NumVerts; I++)
            {
                if (V.IsEqual(m_Verts[I]))
                {
                    // Blend the Normals
                    m_Verts[I].m_Normal += norm;
                    return I;
                }
            }

            // allocate 10 new memory slots for Point Lights if necessary
            if ((m_NumVerts % 10) == 0)
            {
                //Copy The Old Array With one Blank
                Vertex[] Old = new Vertex[m_NumVerts];
                System.Array.Copy(m_Verts, Old, m_NumVerts);

                m_Verts = new Vertex[m_NumVerts + 10];
                System.Array.Copy(Old, m_Verts, m_NumVerts);
            }

            m_Verts[m_NumVerts] = V;
            m_NumVerts++;
            return m_NumVerts - 1;
        }

        #endregion
    }
}
