﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoTriangle : Primitive
    {
        #region " Variables "

        #endregion

        #region " Constructors "

        public GeoTriangle()
        {
            // Set the default values
            m_Triangle = new Triangle();
            m_Triangle.m_Vert1 = 0;
            m_Triangle.m_Vert2 = 0;
            m_Triangle.m_Vert3 = 0;
            m_Triangle.m_FaceNormal = false;
            m_Triangle.m_Normal = new Vector3();
            m_Material = -1;
        }

        public GeoTriangle(int v1, int v2, int v3, bool facenormal, Vector3 norm, int mat)
        {
            // Set the new values
            m_Triangle = new Triangle();
            m_Triangle.m_Vert1 = v1;
            m_Triangle.m_Vert2 = v2;
            m_Triangle.m_Vert3 = v3;
            m_Triangle.m_FaceNormal = facenormal;
            m_Triangle.m_Normal = norm;
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(int v1, int v2, int v3, bool facenormal, Vector3 norm, int mat)
        {
            // Set the new values
            m_Triangle = new Triangle();
            m_Triangle.m_Vert1 = v1;
            m_Triangle.m_Vert2 = v2;
            m_Triangle.m_Vert3 = v3;
            m_Triangle.m_FaceNormal = facenormal;
            m_Triangle.m_Normal = norm;
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        override public int GetKind()
        {
            // return the integer type
            return 3;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            return m_Triangle.m_Normal;
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            Vertex Vert = v[0].Interpolate(pos, v[0], v[1], v[2]);
            // Set the Values
            U = Vert.m_UV.X;
            V = Vert.m_UV.Y;
        }

        #endregion
    }
}
