﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoSphere : Primitive
    {
        #region " Variables "

        public Vector3 m_VPos;
        public Vector3 m_UPos;
        public Vector3 m_CPos;

        #endregion

        #region " Constructors "

        public GeoSphere()
        {
            // Set the default values
            m_Sphere = new Sphere();
            m_VPos = new Vector3();
            m_UPos = new Vector3();
            m_Material = -1;
        }
        public GeoSphere(Sphere sphere, int mat)
        {
            // Set the new values
            m_Sphere = sphere;
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }
        public GeoSphere(Vector3 center, float radius, int mat)
        {
            // Set the new values
            m_Sphere = new Sphere(center, radius);
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(Sphere sphere, int mat)
        {
            // Set the new values
            m_Sphere = sphere;
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }
        public void Set(Vector3 center, float radius, int mat)
        {
            // Set the new values
            m_Sphere = new Sphere(center, radius);
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        public override int GetKind()
        {
            // return the integer type
            return 1;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            Vector3 res = new Vector3();
            // Calculate the Normal of the Sphere
            res = pos - m_Sphere.m_Center;
            res.Normalize();
            return res;
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            Vector3 vp = new Vector3();
            vp = (pos - m_Sphere.m_Center);
            vp.Normalize();
            float phi = (float)Math.Acos(-vp.Dot(m_VPos));
            if (float.IsNaN(phi))
                phi = 0;
            V = phi * (1.0f / (float)System.Math.PI);
            float theta = ((float)Math.Acos(vp.Dot(m_UPos) / (float)Math.Sin(phi))) * (2.0f / (float)Math.PI);
            if (float.IsNaN(theta))
                theta = 0;
            if (vp.Dot(m_CPos) >= 0)
                U = (1.0f - theta);
            else
                U = theta;
        }

        #endregion

    }
}
