﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoPlane : Primitive
    {
        #region " Variables "

        public Vector3 m_UAxis;
        public Vector3 m_VAxis;

        #endregion

        #region " Constructors "

        public GeoPlane()
        {
            // Set the default values
            m_Plane = new Plane();
            m_Material = -1;
        }
        public GeoPlane(Vector3 v0, Vector3 v1, Vector3 v2, int mat)
        {
            // Set the default values
            m_Plane = new Plane(v0, v1, v2);
            m_UAxis = new Vector3(m_Plane.m_Normal.Y, m_Plane.m_Normal.Z, -m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Plane.m_Normal);
            m_Material = mat;
        }
        public GeoPlane(Vector3 norm, Vector3 point, float dist, int mat)
        {
            // Set the default values
            m_Plane = new Plane(norm, point, dist);
            m_UAxis = new Vector3(m_Plane.m_Normal.Y, m_Plane.m_Normal.Z, -m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Plane.m_Normal);
            m_Material = mat;
        }
        
        #endregion

        #region " Methods "

        public void Set(Vector3 v0, Vector3 v1, Vector3 v2, int mat)
        {
            // Set the default values
            m_Plane = new Plane(v0, v1, v2);
            m_UAxis = new Vector3(m_Plane.m_Normal.Y, m_Plane.m_Normal.Z, -m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Plane.m_Normal);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        override public int GetKind()
        {
            // return the integer type
            return 0;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            return m_Plane.m_Normal;
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            // Make the Full UV
            U = pos.Dot(m_UAxis);
            V = pos.Dot(m_VAxis);
        }

        #endregion
    }
}
