﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoEllipsoid: Primitive
    {
        #region " Variables "

        public Vector3 m_VPos;
        public Vector3 m_UPos;
        public Vector3 m_CPos;

        #endregion

        #region " Constructors "

        public GeoEllipsoid()
        {
            // Set the default values
            m_Ellipsoid = new Ellipsoid();
            m_VPos = new Vector3();
            m_UPos = new Vector3();
            m_Material = -1;
        }
        public GeoEllipsoid(Vector3 center, float radius, float yratio, float zratio, int mat)
        {
            // Set the new values
            m_Ellipsoid = new Ellipsoid(center, radius, yratio, zratio);
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 center, float radius, float yratio, float zratio, int mat)
        {
            // Set the new values
            m_Ellipsoid = new Ellipsoid(center, radius, yratio, zratio);
            m_VPos = new Vector3(0, 1, 0);
            m_UPos = new Vector3(1, 0, 0);
            m_CPos = m_UPos.Cross(m_VPos);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        public override int GetKind()
        {
            // return the integer type
            return 5;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            //// Make the 4 extreme radiuses
            //Vector3 Rmin1 = new Vector3();
            //Rmin1.X = m_Ellipsoid.m_Center.X;
            //Vector3 Rmax1 = new Vector3();
            //Rmax1.X = m_Ellipsoid.m_Center.X;
            //Vector3 Rmin2 = new Vector3();
            //Rmin2.X = m_Ellipsoid.m_Center.X;
            //Vector3 Rmax2 = new Vector3();
            //Rmax2.X = m_Ellipsoid.m_Center.X;
            //Rmin1.Y -= m_Ellipsoid.m_Radius * m_Ellipsoid.m_YRatio;
            //Rmin1.Z -= m_Ellipsoid.m_Radius * m_Ellipsoid.m_ZRatio;
            //Rmin2.Y -= m_Ellipsoid.m_Radius * m_Ellipsoid.m_YRatio;
            //Rmin2.Z += m_Ellipsoid.m_Radius * m_Ellipsoid.m_ZRatio;
            //Rmax1.Y += m_Ellipsoid.m_Radius * m_Ellipsoid.m_YRatio;
            //Rmax1.Z += m_Ellipsoid.m_Radius * m_Ellipsoid.m_ZRatio;
            //Rmax2.Y += m_Ellipsoid.m_Radius * m_Ellipsoid.m_YRatio;
            //Rmax2.Z -= m_Ellipsoid.m_Radius * m_Ellipsoid.m_ZRatio;

            //// Find the 4 vectors to the point
            //Vector3 V1 = new Vector3();
            //V1 = pos - Rmin1;
            //Vector3 V2 = new Vector3();
            //V2 = pos - Rmin2;
            //Vector3 V3 = new Vector3();
            //V3 = pos - Rmax1;
            //Vector3 V4 = new Vector3();
            //V4 = pos - Rmax2;

            //Vector3 Tan1 = V1.Cross(V3);
            //Vector3 Tan2 = V4.Cross(V2);

            Vector3 Normal = new Vector3();

            //if (Tan1.Dot(new Vector3(0, 1, 0)) > 0.0f)
            //    Normal = Tan1.Cross(Tan2);
            //else
            //    Normal = Tan2.Cross(Tan1);

                Normal = pos - m_Ellipsoid.m_Center;
                Normal.Normalize();

            return Normal;
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            Vector3 vp = new Vector3();
            vp = (pos - m_Ellipsoid.m_Center);
            vp.Normalize();
            float phi = (float)Math.Acos(-vp.Dot(m_VPos));
            if (float.IsNaN(phi))
                phi = 0;
            V = phi * (1.0f / (float)System.Math.PI);
            float theta = ((float)Math.Acos(vp.Dot(m_UPos) / (float)Math.Sin(phi))) * (2.0f / (float)Math.PI);
            if (float.IsNaN(theta))
                theta = 0;
            if (vp.Dot(m_CPos) >= 0)
                U = (1.0f - theta);
            else
                U = theta;
        }

        #endregion
    }
}
