﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoDisc : Primitive
    {
        #region " Variables "

        Vector3 m_UAxis;
        Vector3 m_VAxis;

        #endregion

        #region " Constructors "

        public GeoDisc()
        {
            // Set the default valeus
            m_Disc = new Disc();
            m_UAxis = new Vector3();
            m_VAxis = new Vector3();
            m_Material = -1;
        }

        public GeoDisc(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius, int mat)
        {
            // Set the new valeus
            m_Disc = new Disc(v1, v2, v3, center, radius);
            m_UAxis = new Vector3(m_Disc.m_Plane.m_Normal.Y, m_Disc.m_Plane.m_Normal.Z, -m_Disc.m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Disc.m_Plane.m_Normal);
            m_Material = mat;
        }

        public GeoDisc(Vector3 norm, Vector3 point, float dist,Vector3 center, float radius, int mat)
        {
            Plane p = new Plane(norm, point, dist);
            // Set the default values
            m_Disc = new Disc(p,center, radius);
            m_UAxis = new Vector3(m_Disc.m_Plane.m_Normal.Y, m_Disc.m_Plane.m_Normal.Z, -m_Disc.m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Disc.m_Plane.m_Normal);
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius, int mat)
        {
            // Set the new valeus
            m_Disc = new Disc(v1, v2, v3, center, radius);
            m_UAxis = new Vector3(m_Disc.m_Plane.m_Normal.Y, m_Disc.m_Plane.m_Normal.Z, -m_Disc.m_Plane.m_Normal.X);
            m_VAxis = m_UAxis.Cross(m_Disc.m_Plane.m_Normal);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        override public int GetKind()
        {
            // return the integer type
            return 4;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            return new Vector3(0, 0, 1);
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
        }

        #endregion
    }
}
