﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    class GeoCylinder : Primitive
    {
        
        #region " Variables "


        #endregion

        #region " Constructors "

        public GeoCylinder()
        {
            // Set the default valeus
            m_Cylinder = new Cylinder();
            m_Material = -1;
        }

        public GeoCylinder(Vector3 start, Vector3 end, float radius, int mat)
        {
            // Set the new valeus
            m_Cylinder = new Cylinder(start, end, radius);
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 start, Vector3 end, float radius, int mat)
        {
            // Set the new valeus
            m_Cylinder = new Cylinder(start, end, radius);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        public override int GetKind()
        {
            // return the integer type
            return 6;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            // Project that point on to the line created by the end points
            Vector3 P = pos.GetClosetPoint(m_Cylinder.m_Start, m_Cylinder.m_End, pos, false);
            Vector3 Norm = pos -P;
            Norm.Normalize();
            return Norm;
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            // Make some UV coordsVector3 vp = new Vector3();
            Vector3 m_VPos = new Vector3(0, 1, 0);
            Vector3 m_UPos = new Vector3(0, 0, -1);
            Vector3 P = pos.GetClosetPoint(m_Cylinder.m_Start, m_Cylinder.m_End, pos, false);
            Vector3 vp = (pos - P);
            vp.Normalize();
            float phi = (float)Math.Acos(-vp.Dot(m_VPos));
            if (float.IsNaN(phi))
                phi = 0;
            V = phi * (1.0f / (float)System.Math.PI);
            U = pos.Dot(m_UPos);

        }

        #endregion
    }
}
