﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Scene.Geometry
{
    public class GeoAABox : Primitive
    {
        #region " Variables "


        #endregion

        #region " Constructors "

        public GeoAABox()
        {
            // Set the default valeus
            m_AABox = new AABox();
            m_Material = -1;
        }

        public GeoAABox(Vector3 min, Vector3 max, int mat)
        {
            // Set the new valeus
            m_AABox = new AABox(min, max);
            m_Material = mat;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 min, Vector3 max, int mat)
        {
            // Set the new valeus
            m_AABox = new AABox(min, max);
            m_Material = mat;
        }

        #endregion

        #region " Overrides "

        public override int GetKind()
        {
            // return the integer type
            return 2;
        }

        override public Vector3 GetNormal(Vector3 pos)
        {
            Vector3 res = new Vector3();
            // Calculate the Normal like a Sphere
            res = pos - m_AABox.m_Center;
            res.Normalize();
            if( (Math.Abs(res.X) > Math.Abs(res.Y) ) & (Math.Abs(res.X)> Math.Abs(res.Z)))
            {
                // Check if its Positive of Negative
                if (res.X > 0)
                    return new Vector3(1, 0, 0);
                else
                    return new Vector3(-1, 0, 0);
            }
            else if( (Math.Abs(res.Y) > Math.Abs(res.X) ) & (Math.Abs(res.Y)> Math.Abs(res.Z)))
            {
                // Check if its Positive of Negative
                if (res.Y > 0)
                    return new Vector3(0, 1, 0);
                else
                    return new Vector3(0, -1, 0);
            }
            else
            {
                // Check if its Positive of Negative
                if (res.Z > 0)
                    return new Vector3(0, 0, 1);
                else
                    return new Vector3(0, 0, -1);
            }
        }

        override public void GetTextureUV(Vector3 pos, ref float U, ref float V, Vertex[] v)
        {
            Colorf col = new Colorf();

            // Find out what Face we are on by the Normal Then Make the 
            Vector3 Norm = GetNormal(pos);

            Vector3 UAxis = new Vector3(Norm.Y, Norm.Z, -Norm.X);
            Vector3 VAxis = UAxis.Cross(Norm);

            U = pos.Dot(UAxis);
            V = pos.Dot(VAxis);
        }

        #endregion
    }
}
