﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using BLSpaceRay.Scene;
using BLSpaceRay.Math3D;

namespace BLSpaceRay.Renderer
{
    public class Renderer
    {
        #region " Variables "

        public Scene.Scene m_Scene;
        public Matrix m_matProj;
        public Matrix m_matView;
        public Matrix m_matInvView;
        public Bitmap m_Image;
        private int m_CurrentLine;
        public Colorf m_BackColor;
        private int m_MaxTransparent;
        private int m_MaxReflections;

        #endregion

        #region " Constructor "

        public Renderer(int width, int height)
        {
            // Set up the Inital values
            m_Scene = new BLSpaceRay.Scene.Scene();
            m_matView = new Matrix();
            m_matInvView = new Matrix();
            m_matProj = new Matrix();
            m_matView.CreateLookAt(new Vector3(0,5, -15), new Vector3(0, 3, 0), new Vector3(0, 1, 0));
            m_matInvView.InverseOf(m_matView);
            m_matProj.CreatePerspectiveFieldOfView((float)Math.PI / 4, width / height, .1f, 1000);
            m_Image = new Bitmap(width, height);
            m_BackColor = new Colorf(1, 0, 0, 0);
            m_CurrentLine = 0;
            m_MaxTransparent = 10;
            m_MaxReflections = 10;
        }

        #endregion

        #region " View Set up"

        public void SetLookAt(Vector3 pos, Vector3 look, Vector3 up)
        {
            // Mak ehte view and the inverse
            m_matView.CreateLookAt(pos, look, up);
            m_matInvView.InverseOf(m_matView);
        }

        public void SetPerspectiveFieldOfView(float FOV, float Aspect, float near, float far)
        {
            // Mak ehte view and the inverse
            m_matProj.CreatePerspectiveFieldOfView(FOV, Aspect, near, far);
        }

        #endregion

        #region " Render Functions "

        public bool Render()
        {
            Ray R;          // Casted ray
	        int Hit=0;      // Clostest hits Index
	        float Depth=0;  // Clostest hits Depth

            // Clostest hits normal
            Vector3 Normal = new Vector3();

            // Color values for the Hit
            Colorf Lit = new Colorf();
            Colorf Reflect = new Colorf();
            Colorf Trans = new Colorf();
            Colorf Fragment = new Colorf(0,0,0,0);
            Colorf Final = new Colorf(0,0,0,0);

            Vertex Verts1;
            Vertex Verts2;
            Vertex Verts3;
            Vertex FinalVert;

            int Value = Environment.TickCount;

            for (int Y = m_CurrentLine; Y < m_Image.Height; Y++)
            {
                for (int X = 0; X < m_Image.Width; X++)
                {

                    // Create the Ray
                    R = MakeRay(X, Y);

                    // Check for collisions
                    if (CheckforCollisions(R, ref Hit, ref Depth))
                    {
                        for (float FragX = X; FragX < X + 1.0f; FragX += 0.5f)
                        {
                            for (float FragY = Y; FragY < Y + 1.0f; FragY += 0.5f)
                            {
                                // Create the Ray
                                R = MakeRay(FragX, FragY);

                                // Check for collisions
                                if (CheckforCollisions(R, ref Hit, ref Depth))
                                {
                                    // Calculate the Normal of the Hit
                                    Normal = m_Scene.m_Geometry.m_Objects[Hit].GetNormal(R.m_Position + (R.m_Direction * Depth));
                                    if (m_Scene.m_Geometry.m_Objects[Hit].GetKind() == 3)
                                    {
                                        if (!m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_FaceNormal)
                                        {
                                            Verts1 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert1];
                                            Verts2 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert2];
                                            Verts3 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert3];
                                            FinalVert = Verts1.Interpolate(R.m_Position + (R.m_Direction * Depth), Verts1, Verts2, Verts3);
                                            Normal = FinalVert.m_Normal;
                                        }
                                        // Normalize the vector
                                        Normal.Normalize();
                                    }
                                    // Get the Lit color
                                    Lit = GetLitColor(R, Hit, Depth, Normal);
                                    // Get the Transparent color
                                    Trans = GetTransparentColor(R, Hit, Depth, Normal, 1);
                                    // Get the Reflection value
                                    Reflect = GetReflectedColor(R, Hit, Depth, Normal, 1);
                                    // Blendthe 3 Colors
                                    Fragment = (Lit + (Reflect * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Reflective))) * ((1 - m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));
                                    Fragment += (Trans * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));

                                    Final += Fragment * 0.25f;
                                    Fragment = new Colorf(0, 0, 0, 0);
                                }
                                else
                                    Final += m_BackColor * 0.25f;

                            }
                        }
                        // Set the Pixel Data
                        m_Image.SetPixel(X, Y, Final.ToSystemColor());
                        Final = new Colorf(0, 0, 0, 0);
                    }
                    else
                        m_Image.SetPixel(X, Y, m_BackColor.ToSystemColor());
                }
                if (Value + 100 < Environment.TickCount)
                {
                    m_CurrentLine = Y + 1;
                    return false;
                }
            }
            m_CurrentLine = 0;
            return true;
        }

        private Ray MakeRay(float X, float Y)
        {
            Vector3 V = new Vector3();
            Ray R = new Ray();

            //Convert the X and Y Pixel point into a 3D point
            V.X = (((2.0F * X) / m_Image.Width) - 1) / m_matProj._11;
            V.Y = -(((2.0F * Y) / m_Image.Height) - 1) / m_matProj._22;
            V.Z = -1.0F;

            //Transform the screen space pick ray into 3D space
            R.m_Direction.X = V.X * m_matInvView._11 + V.Y * m_matInvView._21 + V.Z * m_matInvView._31;
            R.m_Direction.Y = V.X * m_matInvView._12 + V.Y * m_matInvView._22 + V.Z * m_matInvView._32;
            R.m_Direction.Z = V.X * m_matInvView._13 + V.Y * m_matInvView._23 + V.Z * m_matInvView._33;

            R.m_Direction.Normalize();

            R.m_Position.X = m_matInvView._41;
            R.m_Position.Y = m_matInvView._42;
            R.m_Position.Z = m_matInvView._43;

            return R;
        }

        private bool CheckforCollisions(Ray R, ref int Index,ref float Depth)
        {
            float Hit1 = 0;
            float Hit2 = 0;
            float Hit3 = 0;
            float Hit4 = 0;
	        bool ret = false;
	        Depth = -1;

	        // Check for plane Collisions
            for (int P = 0; P < m_Scene.m_Geometry.m_NumObjects; P++)
	        {
                //Select the right type of perimative
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 0)     // Plane
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Plane, false,ref Hit1))
                    {
                        if (Hit1 > .001f)
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 1)     // Sphere
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Sphere, ref Hit1, ref Hit2))
                    {
                        if ((Hit1 > .001f) & (Hit1 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                        if ((Hit2 > .001f) & (Hit2 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit2 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit2;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 2)     // AABox
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_AABox, ref Hit1))
                    {
                        if (Hit1 > .001f)
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 3)     // Triangle
                {
                    Vector3 v1, v2, v3;
                    v1 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[P].m_Triangle.m_Vert1].m_Position;
                    v2 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[P].m_Triangle.m_Vert2].m_Position;
                    v3 = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[P].m_Triangle.m_Vert3].m_Position;
                    if (R.Intersection(v1, v2, v3, ref Hit1))
                    {
                        if (Hit1 > .001f)
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 4)     // Disc
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Disc, ref Hit1))
                    {
                        if (Hit1 > .001f)
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 5)     // Ellipsoid
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Ellipsoid, ref Hit1, ref Hit2))
                    {
                        if ((Hit1 > .001f) & (Hit1 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                        if ((Hit2 > .001f) & (Hit2 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit2 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit2;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 6)     // Cylinder
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Cylinder, ref Hit1, ref Hit2))
                    {
                        if ((Hit1 > .001f) & (Hit1 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                        if ((Hit2 > .001f) & (Hit2 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit2 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit2;
                                ret = true;
                            }
                        }
                    }
                }
                if (m_Scene.m_Geometry.m_Objects[P].GetKind() == 7)     // Torus
                {
                    if (R.Intersection(m_Scene.m_Geometry.m_Objects[P].m_Torus, ref Hit1, ref Hit2, ref Hit3, ref Hit4))
                    {
                        if ((Hit1 > .001f) & (Hit1 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit1 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit1;
                                ret = true;
                            }
                        }
                        if ((Hit2 > .001f) & (Hit2 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit2 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit2;
                                ret = true;
                            }
                        }
                        if ((Hit3 > .001f) & (Hit3 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit3 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit3;
                                ret = true;
                            }
                        }
                        if ((Hit4 > .001f) & (Hit4 != -1))
                        {
                            // Check to see if its closer
                            if ((Hit4 < Depth) | (Depth == -1))
                            {
                                // The Hit was Closter or the first hit
                                Index = P;
                                Depth = Hit4;
                                ret = true;
                            }
                        }
                    }
                }
            }

	        return ret;
        }

        private Colorf GetLitColor(Ray R, int Hit, float Depth, Vector3 Norm)
        {
            Colorf Col = new Colorf(1,1,1,1);
            Colorf SpecCol = new Colorf(1, 1, 1, 1);
            Colorf Ambi = new Colorf(0, 0, 0);
            Colorf Light = new Colorf(0, 0, 0);
            Colorf Diff = new Colorf(0, 0, 0);
            Colorf Spec = new Colorf(0, 0, 0);
            bool Shadowed = false;
            float Dot = 0;
            float POW = 0;
            Vector3 V = R.m_Direction;
            Vector3 NegD = new Vector3();
            Vector3 Re;
            Vector3 pos = R.m_Position + (R.m_Direction * Depth);
            Vector3 L = new Vector3();
            Ray Lit = new Ray();
            float A=0;
            int B=0;
            float C = 0;
            float D = 0;
            float Distance = 0;
            Vertex[] Verts = new Vertex[3];
            Vertex FinalVert = new Vertex();
            if (m_Scene.m_Geometry.m_Objects[Hit].GetKind() == 3)
            {
                Verts[0] = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert1];
                Verts[1] = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert2];
                Verts[2] = m_Scene.m_Geometry.m_Verts[m_Scene.m_Geometry.m_Objects[Hit].m_Triangle.m_Vert3];
                FinalVert = FinalVert.Interpolate(pos, Verts[0], Verts[1], Verts[2]);
            }

            float texU = 0, texV = 0;

            if (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Textured)
            {
                // Get The Texture UV's
                if (m_Scene.m_Geometry.m_Objects[Hit].GetKind() == 3) 
                {
                    texU = FinalVert.m_UV.X;
                    texV = FinalVert.m_UV.Y;
                    Col = FinalVert.m_Color;
                }
                else
                {
                    m_Scene.m_Geometry.m_Objects[Hit].GetTextureUV(pos, ref texU, ref texV, null);
                }
                texU = texU * m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_UScale;
                texV = texV * m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_VScale;
                // Get the Textur Colors
                for (int I = 0; I < m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_NumTextures; I++)
                {
                    Col *= m_Scene.m_Materials.m_Textures[m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Textures[I]].GetTexel(texU, texV);
                }
            }
            else
            {
                // Not textured
                if (m_Scene.m_Geometry.m_Objects[Hit].GetKind() == 3) 
                {
                    Col = FinalVert.m_Color * m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Diffuse;
                }
                else
                {
                    Col = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Diffuse;
                }
                
            }

            POW = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_SpecularPOW;
            SpecCol = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Specular;

            // Get the Ambient Value
            Ambi = Col * (m_Scene.m_Lighting.m_Ambient * m_Scene.m_Lighting.m_AmbientIntensity);


            // Loop through all the lights
            for (int P = 0; P < m_Scene.m_Lighting.m_NumLights; P++)
            {
                if (m_Scene.m_Lighting.m_Lights[P].m_Shadowed)
                {
                    switch (m_Scene.m_Lighting.m_Lights[P].GetKind())
                    {
                        case 0:     // Direction
                            // Build the ray
                            Lit.m_Position = R.m_Position + (R.m_Direction * Depth);
                            Lit.m_Position += Norm * MathHelper.Epsilon;
                            Lit.m_Direction.X = -m_Scene.m_Lighting.m_Lights[P].m_Direction.X;
                            Lit.m_Direction.Y = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Y;
                            Lit.m_Direction.Z = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Z;
                            break;
                        case 1:     // Point
                            // Build the ray
                            Lit.m_Position = R.m_Position + (R.m_Direction * Depth);
                            Lit.m_Direction = m_Scene.m_Lighting.m_Lights[P].m_Position - pos;
                            Lit.m_Direction.Normalize();
                            Lit.m_Position += Norm * MathHelper.Epsilon;
                            // Calculate the distance to the light
                            Distance = Lit.m_Position.Distance(R.m_Position + (R.m_Direction * Depth), m_Scene.m_Lighting.m_Lights[P].m_Position);
                            break;
                        case 2:     // Spot
                            // Build the ray
                            Lit.m_Position = R.m_Position + (R.m_Direction * Depth);
                            Lit.m_Direction = m_Scene.m_Lighting.m_Lights[P].m_Position - pos;
                            Lit.m_Direction.Normalize();
                            Lit.m_Position += Norm * MathHelper.Epsilon;
                            // Calculate the distance to the light
                            Distance = Lit.m_Position.Distance(R.m_Position + (R.m_Direction * Depth), m_Scene.m_Lighting.m_Lights[P].m_Position);
                            break;
                    }
                    // Check for collisions
                    if (CheckforCollisions(Lit, ref B, ref A))
                    {
                        if (A < Distance)
                        {
                            Shadowed = true;
                        }
                        else
                        {
                            Shadowed = false;
                        }
                    }
                    else
                    {
                        Shadowed = false;
                    }
                    Distance = 0;
                }
                if (!Shadowed)
                {
                    switch (m_Scene.m_Lighting.m_Lights[P].GetKind())
                    {
                        case 0:     // Direction
                            // Calulate Diffuse Colors
                            L.X = -m_Scene.m_Lighting.m_Lights[P].m_Direction.X;
                            L.Y = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Y;
                            L.Z = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Z;
                            L.Normalize();
                            Dot = Norm.Dot(L);
                            if (Dot > 0)
                            {
                                Light = (m_Scene.m_Lighting.m_Lights[P].m_Color * m_Scene.m_Lighting.m_Lights[P].m_Constant);
                                Diff += (Col * Light) * Dot;
                                // Calculate Specular Colors				
                                if (POW > 0)
                                {
                                    Re = L - (Norm * L.Dot(Norm)) * 2.0f;
                                    Dot = V.Dot(Re);
                                    if (Dot > 0)
                                    {
                                        float spec = (float)System.Math.Pow(Dot, (float)POW);
                                        // add specular component to ray color
                                        Spec += SpecCol * spec;
                                    }
                                }
                            }
                            break;
                        case 1:     // Point
                            // Calulate Diffuse Colors
                            L = m_Scene.m_Lighting.m_Lights[P].m_Position - pos;
                            L.Normalize();
                            Dot = Norm.Dot(L);
                            if (Dot > 0)
                            {
                                D = m_Scene.m_Lighting.m_Lights[P].m_Position.Distance(m_Scene.m_Lighting.m_Lights[P].m_Position, (R.m_Position + (R.m_Direction * Depth)));
                                Light = (1 / (m_Scene.m_Lighting.m_Lights[P].m_Constant + m_Scene.m_Lighting.m_Lights[P].m_Linear * D + m_Scene.m_Lighting.m_Lights[P].m_Quadratic * D * D)) * m_Scene.m_Lighting.m_Lights[P].m_Color;
                                Diff += (Col * Light) * Dot;
                                // Calculate Specular Colors
                                if (POW > 0)
                                {
                                    Re = L - (Norm * L.Dot(Norm)) * 2.0f;
                                    Dot = V.Dot(Re);
                                    if (Dot > 0)
                                    {
                                        float spec = (float)System.Math.Pow(Dot, (float)POW);
                                        // add specular component to ray color
                                        Spec += SpecCol * spec;
                                    }
                                }
                            }
                            break;
                        case 2:     // Spot
                            // Calulate Diffuse Colors
                            L = m_Scene.m_Lighting.m_Lights[P].m_Position - pos;
                            L.Normalize();
                            Dot = Norm.Dot(L);
                            if (Dot > 0)
                            {
                                NegD.X = -m_Scene.m_Lighting.m_Lights[P].m_Direction.X;
                                NegD.Y = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Y;
                                NegD.Z = -m_Scene.m_Lighting.m_Lights[P].m_Direction.Z;
                                C = NegD.Dot(L);
                                C = (float)System.Math.Pow(C, m_Scene.m_Lighting.m_Lights[P].m_POW);
                                if (C < 0)
                                    C = 0;
                                D = m_Scene.m_Lighting.m_Lights[P].m_Position.Distance(m_Scene.m_Lighting.m_Lights[P].m_Position, (R.m_Position + (R.m_Direction * Depth)));
                                Light = ( C/ (m_Scene.m_Lighting.m_Lights[P].m_Constant + m_Scene.m_Lighting.m_Lights[P].m_Linear * D + m_Scene.m_Lighting.m_Lights[P].m_Quadratic * D * D)) * m_Scene.m_Lighting.m_Lights[P].m_Color;
                                Diff += (Col * Light) * Dot;
                                // Calculate Specular Colors
                                if (POW > 0)
                                {
                                    Re = L - (Norm * L.Dot(Norm)) * 2.0f;
                                    Dot = V.Dot(Re);
                                    if (Dot > 0)
                                    {
                                        float spec = (float)System.Math.Pow(Dot, (float)POW);
                                        // add specular component to ray color
                                        Spec += SpecCol * spec;
                                    }
                                }
                            }
                            break;
                    }
                }
            }
            return Ambi + Diff + Spec;
        }

        private Colorf GetReflectedColor(Ray R, int Hit, float Depth, Vector3 Norm, int Loop)
        {
            float Reflective = 0;
            int THit = -1;
            float TDepth = 0;

            // Color Values
            Colorf Lit;
            Colorf Trans = new Colorf();
            Colorf Reflect = new Colorf();
            Colorf Final;

            // normal value
            Vector3 Normal;

            //Reflected Ray
            Ray RefR = new Ray();

             Reflective = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Reflective;
            // Check if its transparent at all
            if ((Reflective == 0) | (Loop == m_MaxReflections))
                return new Colorf(0, 0, 0, 0);

            // Calculate the Reflected Ray
            RefR.m_Position = R.m_Position + R.m_Direction * Depth;
            // Move the New Ray Alittle away from the point to avoid Colliding with itsself
            RefR.m_Position = RefR.m_Position + Norm * MathHelper.Epsilon;
            RefR.m_Direction = 2 * (Norm.Dot(R.GetNegDir())) * Norm - (R.GetNegDir());
            //RefR.m_Direction = (Norm - (R.GetNegDir())) * 2 * Norm.Dot(R.GetNegDir());


            // Check for Collisions
            if (CheckforCollisions(RefR, ref THit, ref TDepth))
            {
                Normal = m_Scene.m_Geometry.m_Objects[THit].GetNormal(RefR.GetPosistion(TDepth));
                // Get the Lit color
                Lit = GetLitColor(RefR, THit, TDepth, Normal);
                // Get the Transparent color
                Trans = GetTransparentColor(RefR, THit, TDepth, Normal, 1);
                // Get the Reflection value
                Reflect = GetReflectedColor(RefR, THit, TDepth, Normal, Loop+1);
                // Blendthe 3 Colors
                Final = (Lit + (Reflect * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Reflective))) * ((1 - m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));
                Final += (Trans * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));
            }
            else
            {
                // There wasn't a collsion
                Final = m_BackColor;
            }

            // Return The Color
            return Final;
        }

        private Colorf GetTransparentColor(Ray R, int Hit, float Depth, Vector3 Norm, int Loop)
        {
	        float Transparency;
	        float Diffraction;
	        Ray	RD = new Ray();
	        int THit=-1;
	        float TDepth=0;
        		
	        // Color Values
	        Colorf Lit;
	        Colorf Trans;
	        Colorf Reflect;
	        Colorf Final;

	        // normal value
	        Vector3 Normal;

	        Transparency = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent;
            Diffraction = m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Diffraction;


	        // Check if its transparent at all
	        if ((Transparency == 0) | (Loop == m_MaxTransparent))
		        return new Colorf(0,0,0,0);

	        if (Diffraction == 0)
	        {
		        // No Diffraction
		        RD.m_Position = R.m_Position + (R.m_Direction * Depth);
                RD.m_Position = RD.m_Position - Norm * MathHelper.Epsilon;
		        RD.m_Direction = R.m_Direction;
	        }
	        else
	        {
		        // Calculate the Diffraction Ray
		        float n = 1 / Diffraction;
		        float cosI = (float)Math.Abs(Norm.Dot(R.m_Direction));

		        float cosT2 = 1.0f - n * n * (1.0f - cosI * cosI);
		        if (cosT2 > 0.0f)
		        {
                    RD.m_Position = R.m_Position + (R.m_Direction * Depth + MathHelper.Epsilon);
                    RD.m_Position = RD.m_Position - Norm * MathHelper.Epsilon;
			        RD.m_Direction= (R.m_Direction * n) +  Norm * (n * cosI - (float)Math.Sqrt( cosT2 ));
		        }

	        }

	        // Check for Collisions
	        if(CheckforCollisions(RD,ref THit,ref TDepth))
	        {
                Normal = m_Scene.m_Geometry.m_Objects[THit].GetNormal(RD.GetPosistion(TDepth));
                // Get the Lit color
                Lit = GetLitColor(RD, THit, TDepth, Normal);
                // Get the Transparent color
                Trans = GetTransparentColor(RD, THit, TDepth, Normal, Loop +1);
                // Get the Reflection value
                Reflect = GetReflectedColor(RD, THit, TDepth, Normal, 1);
                // Blendthe 3 Colors
                Final = (Lit + (Reflect * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Reflective))) * ((1 - m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));
                Final += (Trans * (m_Scene.m_Materials.m_Surfaces[m_Scene.m_Geometry.m_Objects[Hit].m_Material].m_Transparent));
	        }
	        else
	        {	
		        // There wasn't a collsion
                Final = m_BackColor;
	        }

	        // Return The Color
	        return Final;
        }
        #endregion
    }
}
