﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Vector3
    {
        #region " Variables "

        public float X;
        public float Y;
        public float Z;

        #endregion

        #region " Constructors "

        public Vector3()
        {
            // Set the default values
            X = 0f;
            Y = 0f;
            Z = 0f;
        }
        public Vector3(float _x, float _y, float _z)
        {
            // Set the new values
            X = _x;
            Y = _y;
            Z = _z;
        }

        #endregion

        #region " Methods "

        public void Set(float _x, float _y, float _z)
        {
            X = _x;
            Y = _y;
            Z = _z;
        }
        public float GetLength()
        {
            float f = 0;

            f = (float)System.Math.Sqrt(X * X + Y * Y + Z * Z);
            return f;
        }
        public float GetSqrLength()
        {
            return (X * X + Y * Y + Z * Z);
        }
        public void Negate()
        {
            X = -X;
            Y = -Y;
            Z = -Z;
        }
        public void Normalize()
        {
            float f = (float)System.Math.Sqrt(X * X + Y * Y + Z * Z);

            if (f != 0.0f)
            {
                X /= f; Y /= f; Z /= f;
            }
        }
        public float Distance(Vector3 v1, Vector3 v2)
        {
            Vector3 v;
            v = v1 - v2;
            return v.GetLength();
        }
        public void RotateWith(Matrix m)
        {
            // applying rotational part of matrix only
            float _x = X * m._11 + Y * m._21 + Z * m._31;
            float _y = X * m._12 + Y * m._22 + Z * m._32;
            float _z = X * m._13 + Y * m._23 + Z * m._33;
            X = _x;
            Y = _y;
            Z = _z;
        }
        public void InvRotateWith(Matrix m)
        {
            // using transposed matrix
            float _x = X * m._11 + Y * m._12 + Z * m._13;
            float _y = X * m._21 + Y * m._22 + Z * m._23;
            float _z = X * m._31 + Y * m._32 + Z * m._33;
            X = _x;
            Y = _y;
            Z = _z;
        }
        public Vector3 GetClosetPoint(Vector3 A, Vector3 B, Vector3 P, bool Clamp)
        {
            Vector3 AP = P - A;
            Vector3 AB = B - A;
            float ab2 = AB.X * AB.X + AB.Y * AB.Y + AB.Z * AB.Z;
            float ap_ab = AP.X * AB.X + AP.Y * AB.Y + AP.Z * AB.Z;
            float t = ap_ab / ab2;
            if (Clamp)
            {
                if (t < 0.0F)
                    t = 0.0F;
                else if (t > 1.0F)
                    t = 1.0F;
            }
            Vector3 Closest = A + AB * t;
            return Closest;
        }
        public float Dot(Vector3 vec)
        {
            return X * vec.X + Y * vec.Y + Z * vec.Z;
        }
        public Vector3 Cross(Vector3 vec)
        {
            Vector3 res = new Vector3();
            res.X = Y * vec.Z - Z * vec.Y;
            res.Y = Z * vec.X - X * vec.Z;
            res.Z = X * vec.Y - Y * vec.X;
            return res;
        }

        #endregion

        #region " Operators "

        public static Vector3 operator *(Vector3 v, float s)
        {
            return new Vector3(v.X * s, v.Y * s, v.Z * s);
        }
        public static Vector3 operator *(float s, Vector3 v)
        {
            return new Vector3(v.X * s, v.Y * s, v.Z * s);
        }
        public static Vector3 operator /(Vector3 v, float s)
        {
            return new Vector3(v.X / s, v.Y / s, v.Z / s);
        }
        public static Vector3 operator /(float s, Vector3 v)
        {
            return new Vector3(v.X / s, v.Y / s, v.Z / s);
        }
        public static Vector3 operator -(Vector3 v1, Vector3 v2)
        {
            return new Vector3(v1.X - v2.X, v1.Y - v2.Y, v1.Z - v2.Z);
        }
        public static Vector3 operator -(Vector3 v, float s)
        {
            return new Vector3(v.X - s, v.Y - s, v.Z - s);
        }
        public static Vector3 operator -(float s, Vector3 v)
        {
            return new Vector3(v.X - s, v.Y - s, v.Z - s);
        }
        public static Vector3 operator +(Vector3 v1, Vector3 v2)
        {
            return new Vector3(v1.X + v2.X, v1.Y + v2.Y, v1.Z + v2.Z);
        }
        public static Vector3 operator +(Vector3 v, float s)
        {
            return new Vector3(v.X + s, v.Y + s, v.Z + s);
        }
        public static Vector3 operator +(float s, Vector3 v)
        {
            return new Vector3(v.X + s, v.Y + s, v.Z + s);
        }

        #endregion
    }
}
