﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Vector2
    {
        #region " Variables "

        public float X;
        public float Y;

        #endregion

        #region " Constructors "

        public Vector2()
        {
            // Set the default values
            X = 0f;
            Y = 0f;
        }
        public Vector2(float _x, float _y)
        {
            // Set the new values
            X = _x;
            Y = _y;
        }

        #endregion

        #region " Methods "

        public void Set(float _x, float _y)
        {
            // Set the new values
            X = _x;
            Y = _y;
        }
        public float GetLength()
        {
	        return (float)System.Math.Sqrt(X*X + Y*Y);
        }
        public float GetSqrLength()
        {
	        return (X*X + Y*Y); 
        }
        public void Negate()
        {
	        X = -X;
	        Y = -Y;
        }
        public void Normalize()
        {
            float f = (float)System.Math.Sqrt(X * X + Y * Y);

	        if (f != 0.0f)
	        {
		        X/=f; Y/=f;
	        }
        }

        #endregion

        #region " Operators "

        public static Vector2 operator *(Vector2 v1, Vector2 v2)
        {
            return new Vector2(v1.X * v2.X, v1.Y * v2.Y);
        }
        public static Vector2 operator *(Vector2 c, float s)
        {
            return new Vector2(c.X * s, c.Y * s);
        }
        public static Vector2 operator *(float s, Vector2 c)
        {
            return new Vector2(c.X * s, c.Y * s);
        }
        public static Vector2 operator /(Vector2 v1, Vector2 v2)
        {
            return new Vector2(v1.X / v2.X, v1.Y / v2.Y);
        }
        public static Vector2 operator /(Vector2 c, float s)
        {
            return new Vector2(c.X / s, c.Y / s);
        }
        public static Vector2 operator /(float s, Vector2 c)
        {
            return new Vector2(c.X / s, c.Y / s);
        }
        public static Vector2 operator -(Vector2 v1, Vector2 v2)
        {
            return new Vector2(v1.X - v2.X, v1.Y - v2.Y);
        }
        public static Vector2 operator -(Vector2 c, float s)
        {
            return new Vector2(c.X - s, c.Y - s);
        }
        public static Vector2 operator -(float s, Vector2 c)
        {
            return new Vector2(c.X - s, c.Y - s);
        }
        public static Vector2 operator +(Vector2 v1, Vector2 v2)
        {
            return new Vector2(v1.X + v2.X, v1.Y + v2.Y);
        }
        public static Vector2 operator +(Vector2 c, float s)
        {
            return new Vector2(c.X + s, c.Y + s);
        }
        public static Vector2 operator +(float s, Vector2 c)
        {
            return new Vector2(c.X + s, c.Y + s);
        }

        #endregion
    }
}
