﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Ray
    {
        #region " Varaibles "

        public Vector3 m_Position;
        public Vector3 m_Direction;

        #endregion

        #region " Contrustors "

        public Ray()
        {
            // Set the default value
            m_Position = new Vector3();
            m_Direction = new Vector3();
        }
        public Ray(Vector3 pos, Vector3 dir)
        {
            // Set the new value
            m_Position = pos;
            m_Direction = dir;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 pos, Vector3 dir)
        {
            // Set the new value
            m_Position = pos;
            m_Direction = dir;
        }
        public Vector3 GetPosistion(float T)
        {
	        // Make a Vector baised on the length of travel for the Ray
	        Vector3 res;
	        res = m_Position + (m_Direction * T);
	        return res;
        }
        public Vector3 GetNegDir()
        {
	        Vector3 res = new Vector3();
	        res.X = -m_Direction.X;
	        res.Y = -m_Direction.Y;
	        res.Z = -m_Direction.Z;
	        return res;
        }

        #endregion

        #region " Intersections "

        public bool Intersection(Sphere s, ref float T1, ref float T2)
        {
	        Vector3 dst = m_Position - s.m_Center;
            float B = dst.Dot(m_Direction);
            float C = dst.Dot(dst) - s.m_Radius * s.m_Radius ;
            float D = B * B - C;  // Discriminant
            if (D < .0001f)
                return false;
            float sqrtD = (float)System.Math.Sqrt(D);


            float t0 = (-B - sqrtD);    // Will always be the smaller, but may be negative
            float t1 = (-B + sqrtD);	// The second intersection, if you care

            T1 = t0;
            T2 = t1;

            // Check for intersections behind the Ray
            if (t0 < 0)
                T1 = -1;
            if (t1 < 0)
                T2 = -1;
	        if ((t0 < 0) & (t1 < 0))
		        return false;
            return true;
        }

        public bool Intersection(Plane p, bool Cull,ref float t)
        {
	        float Vd = p.m_Normal.Dot(m_Direction);

	        // ray parallel to plane
	        if (System.Math.Abs(Vd) < 0.00001f)
	        {
		        return false;
	        }
	        // normal pointing away from ray dir
	        // => intersection backface if any
	        if (Cull && (Vd > 0.0f))
	        {
		        return false;
	        }
	        float Vo = -( (p.m_Normal.Dot(m_Position)) + p.m_Distance);

	        float _t = Vo / Vd;

	        // intersection behind ray origin
	        if (_t < 0.0f)
	        {
		        return false;
	        }
            
            t = _t;
	        return true;
        }

        public bool Intersection(AABox b,ref float t)
        {
	        float t0, t1, tmp;
	        float tNear = -999999.9f;
	        float tFar  =  999999.9f;
	        float epsilon = 0.00001f;

	        // first pair of planes
            if (System.Math.Abs(m_Direction.X) < epsilon)
	        {
		        if ( (m_Position.X < b.m_Min.X) || (m_Position.X > b.m_Max.X) )
		        {
			        return false;
		        }
	        }
	        t0 = (b.m_Min.X - m_Position.X) / m_Direction.X;
	        t1 = (b.m_Max.X - m_Position.X) / m_Direction.X;
	        if (t0 > t1)
	        { 
		        tmp=t0;
		        t0=t1;
		        t1=tmp;
	        }
	        if (t0 > tNear) 
	        {
		        tNear = t0;
	        }
	        if (t1 < tFar)
	        {
		        tFar = t1;
	        }
	        if (tNear > tFar) 
	        {
		        return false;
	        }
	        if (tFar < 0)
	        {
		        return false;
	        }
	        // second pair of planes
            if (System.Math.Abs(m_Direction.Y) < epsilon)
	        {
		        if ( (m_Position.Y < b.m_Min.Y) || (m_Position.Y > b.m_Max.Y) )
		        {
		        return false;
		        }
	        }
	        t0 = (b.m_Min.Y - m_Position.Y) / m_Direction.Y;
	        t1 = (b.m_Max.Y - m_Position.Y) / m_Direction.Y;
	        if (t0 > t1)
	        {
		        tmp=t0;
		        t0=t1;
		        t1=tmp;
	        }
	        if (t0 > tNear)
	        {
		        tNear = t0;
	        }
	        if (t1 < tFar)
	        {
		        tFar = t1;
	        }
	        if (tNear > tFar)
	        {
		        return false;
	        }
	        if (tFar < 0)
	        {
		        return false;
	        }

	        // third pair of planes
            if (System.Math.Abs(m_Direction.Z) < epsilon)
	        {
		        if ( (m_Position.Z < b.m_Min.Z) || (m_Position.Z > b.m_Max.Z) )
		        {
			        return false;
		        }
	        }
	        t0 = (b.m_Min.Z - m_Position.Z) / m_Direction.Z;
	        t1 = (b.m_Max.Z - m_Position.Z) / m_Direction.Z;
	        if (t0 > t1)
	        {
		        tmp=t0;
		        t0=t1;
		        t1=tmp;
	        }
	        if (t0 > tNear)
	        {
		        tNear = t0;
	        }
	        if (t1 < tFar)
	        {
		        tFar = t1;
	        }
	        if (tNear > tFar)
	        {
		        return false;
	        }
	        if (tFar < 0)
	        {
		        return false;
	        }


	        if (tNear > 0) 
	        {
		        t = tNear;
	        }
	        else
	        { 
		        t = tFar;
	        }
	        return true;
        }

        public bool Intersection(Disc Disc, ref float Hit)
        {
            Vector3 P;
            Vector3 D;
            float Dist;
            if (Intersection(Disc.m_Plane, false,ref Hit))
            {
                // Is the Point with in the radius
                P = m_Position + m_Direction * Hit;
                D = P - Disc.m_Center;
                Dist = D.Dot(D);
                if (Dist <= Disc.m_Radius)
                    return true;
            }
            return false;
        }

        public bool Intersection(Ellipsoid E, ref float T1, ref float T2)
        {
            Vector3 dst = m_Position - E.m_Center;
            float A = m_Direction.X * m_Direction.X + E.m_YRatio * E.m_YRatio * m_Direction.Y * m_Direction.Y + E.m_ZRatio * E.m_ZRatio * m_Direction.Z * m_Direction.Z;
            float B = 2*(dst.X * m_Direction.X + E.m_YRatio * E.m_YRatio * dst.Y * m_Direction.Y + E.m_ZRatio * E.m_ZRatio * dst.Z * m_Direction.Z);
            float C = dst.X * dst.X + E.m_YRatio * E.m_YRatio * dst.Y * dst.Y + E.m_ZRatio * E.m_ZRatio * dst.Z * dst.Z - E.m_Radius * E.m_Radius;
            float D = B * B - 4 * A * C;  // Discriminant
            if (D < .0001f)
                return false;
            float sqrtD = (float)System.Math.Sqrt(D);


            float t0 = (-B - sqrtD) / (2 * A);    // Will always be the smaller, but may be negative
            float t1 = (-B + sqrtD) / (2 * A);	// The second intersection, if you care

            T1 = t0;
            T2 = t1;

            // Check for intersections behind the Ray
            if (t0 < 0)
                T1 = -1;
            if (t1 < 0)
                T2 = -1;
            if ((t0 < 0) & (t1 < 0))
                return false;
            return true;
        }

        public bool Intersection(Cylinder O, ref float T1, ref float T2)
        {
            //--------------------------------------------------------------------------
            // Ray : P(t) = O + V * t
            // Cylinder [O, D, r].
            // point Q on cylinder if ((Q - O) x D)^2 = r^2
            //
            // Cylinder [A, B, r].
            // Point P on infinite cylinder if ((P - A) x (B - A))^2 = r^2 * (B - A)^2
            // expand : ((O - A) x (B - A) + t * (V x (B - A)))^2 = r^2 * (B - A)^2
            // equation in the form (X + t * Y)^2 = d
            // where : 
            //  X = (O - A) x (B - A)
            //  Y = V x (B - A)
            //  d = r^2 * (B - A)^2
            // expand the equation :
            // t^2 * (Y . Y) + t * (2 * (X . Y)) + (X . X) - d = 0
            // => second order equation in the form : a*t^2 + b*t + c = 0 where
            // a = (Y . Y)
            // b = 2 * (X . Y)
            // c = (X . X) - d
            //--------------------------------------------------------------------------
            Vector3 AB = (O.m_End - O.m_Start);
            Vector3 AO = (m_Position - O.m_Start);
            Vector3 AOxAB = AO.Cross(AB); // cross product
            Vector3 VxAB = m_Direction.Cross(AB); // cross product
            float ab2 = AB.Dot(AB); // dot product
            float A = VxAB.Dot(VxAB); // dot product
            float B = 2 * VxAB.Dot(AOxAB); // dot product
            float C = AOxAB.Dot(AOxAB) - (O.m_Radius * O.m_Radius * ab2);

            //float D = B * B - C;  // Discriminant
            float D = B * B - 4 * A * C;  // Discriminant
            if (D < -.001f)
                return false;
            float sqrtD = (float)System.Math.Sqrt(D);


            float t0 = (-B - sqrtD) / (2 * A);    // Will always be the smaller, but may be negative
            float t1 = (-B + sqrtD) / (2 * A);	// The second intersection, if you care

            // Check for intersections behind the Ray
            if ((t0 < 0) & (t1 < 0))
                return false;

            T1 = t0;
            T2 = t1;

            // Project that point on to the line created by the end points
            Vector3 P;
            P = AB.GetClosetPoint(O.m_Start, O.m_End, m_Position + m_Direction * t0, false);


            // Is the point on the line
            float d1 = P.Distance(P, O.m_Start);
            float d2 = P.Distance(P, O.m_End);
            float d3 = P.Distance(O.m_Start, O.m_End);

            if (d1 + d2 > d3 + .001f)
                T1 = -1;


            P = AB.GetClosetPoint(O.m_Start, O.m_End, m_Position + m_Direction * t1, false);


            // Is the point on the line
            d1 = P.Distance(P, O.m_Start);
            d2 = P.Distance(P, O.m_End);
            d3 = P.Distance(O.m_Start, O.m_End);

            if (d1 + d2 > d3 + .001f)
                T2 = -1;

            if ((T1 == -1) & (T2 == -1))
                return false;

            return true;
        }

        public bool Intersection(Torus T, ref float T1, ref float T2, ref float T3, ref float T4)
        {
            // Make the coefficients
            float A = m_Direction.Dot(m_Direction) * m_Direction.Dot(m_Direction);
            float B = 4 * m_Direction.Dot(m_Direction) * m_Position.Dot(m_Direction);
            float C = 4 * m_Position.Dot(m_Direction) * m_Position.Dot(m_Direction) + 2 * (m_Direction.Dot(m_Direction) * (m_Position.Dot(m_Position) - T.m_Radius1 * T.m_Radius1 - T.m_Radius2 * T.m_Radius2)) + 4 * T.m_Radius1 * T.m_Radius1 + m_Direction.Z * m_Direction.Z;
            float D = 4 * (m_Position.Dot(m_Direction) * (m_Position.Dot(m_Position) - T.m_Radius1 * T.m_Radius1 - T.m_Radius2 * T.m_Radius2)) + 8 * T.m_Radius1 * T.m_Radius1 + m_Position.Z * m_Direction.Z;
            float E = (m_Position.Dot(m_Position) - T.m_Radius1 * T.m_Radius1 - T.m_Radius2 * T.m_Radius2) * (m_Position.Dot(m_Position) - T.m_Radius1 * T.m_Radius1 - T.m_Radius2 * T.m_Radius2) + 4 * T.m_Radius1 * T.m_Radius1 + m_Position.Z * m_Position.Z - 4 * T.m_Radius1 * T.m_Radius1 * T.m_Radius2 * T.m_Radius2;
            float[] roots = new float [4];
            int n = RootSolver.SolveQuartic(A, B, C, D, E,ref roots);
            if (n == 0)
                return false;
            else
                return true;
        }

        public bool Intersection(Vector3 V0, Vector3 V1, Vector3 V2, ref float Hit)
        {
            Vector3 u, v, n;        //Triangle vectors
            Vector3 w0, w;          //ray vectors
            Vector3 HitP;
            float c, a, b;         //params to calc ray-plane intersect
            //get triangle edge vectors and plane normal
            u = V1 - V0;
            v = V2 - V0;
            n = u.Cross(v);    //cross product
            if (n == new Vector3(0, 0, 0))       //triangle is degenerate
                return false;           //do not deal with this case

            w0 = m_Position - V0;
            a = -n.Dot(w0);
            b = n.Dot(m_Direction);
            if (System.Math.Abs(b) < .0001f)   //ray is parallel to triangle plane
            {
                if (a == 0)
                    return false;               //ray lies in triangle plane
                else
                    return false;               //ray disjoint from plane
            }

            //get intersect point of ray with triangle plane
            c = a / b;
            if (c < 0.0)            //ray goes away from triangle
                return false;      //=> no intersect

            //for a segment, also test if (r > 1.0) => no intersect

            Hit = c;           //intersect point of ray and plane
            HitP = m_Position + c * m_Direction;

            //is Hit inside T?
            float uu, uv, vv, wu, wv, D;
            uu = u.Dot(u);
            uv = u.Dot(v);
            vv = v.Dot(v);
            w = HitP - V0;
            wu = w.Dot(u);
            wv = w.Dot(v);
            D = uv * uv - uu * vv;

            //get and test parametric coords
            float s, t;
            s = (uv * wv - vv * wu) / D;
            if (s < 0.0 || s > 1.0)         //I is outside T
                return false;
            t = (uv * wu - uu * wv) / D;
            if (t < 0.0 || (s + t) > 1.0)   //I is outside T
                return false;
            return true;                     //I is in T
        }

        #endregion
    }
}
