﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Matrix
    {
        #region " Variables"

        public float _11, _12, _13, _14;
        public float _21, _22, _23, _24;
        public float _31, _32, _33, _34;
        public float _41, _42, _43, _44;

        #endregion
        
        #region " Constructors "

        public Matrix()
        {
            // Set the matrix identity
            Identity();
        }

        #endregion

        #region " Methods "

        public void Identity()
        {
            // Set the identity matrix
            _12 = _13 = _14 = _21 = _23 = _24 = _31 = _32 = _34 = _41 = _42 = _43 = 0.0f;
            _11 = _22 = _33 = _44 = 1.0f;
        }
        public void Zero()
        {
            // Set the identity matrix
            _12 = _13 = _14 = _21 = _23 = _24 = _31 = _32 = _34 = _41 = _42 = _43 = 0.0f;
            _11 = _22 = _33 = _44 = 0.0f;
        }
        public void RotationX(float deg)
        {
            float c, s;
            // Do the Path math once
            c = (float)System.Math.Cos(deg);
            s = (float)System.Math.Sin(deg);
            // Load an Identity
            Identity();
            // Set the Rotation matrix around X
            _22 = c;
            _23 = -s;
            _32 = s;
            _33 = c;
        }
        public void RotationY(float deg)
        {
            float c, s;
            // Do the Path math once
            c = (float)System.Math.Cos(deg);
            s = (float)System.Math.Sin(deg);
            // Load an Identity
            Identity();
            // Set the Rotation matrix around X
            _11 = c;
            _31 = -s;
            _13 = s;
            _33 = c;
        }
        public void RotationZ(float deg)
        {
            float c, s;
            // Do the Path math once
            c = (float)System.Math.Cos(deg);
            s = (float)System.Math.Sin(deg);
            // Load an Identity
            Identity();
            // Set the Rotation matrix around X
            _11 = c;
            _21 = -s;
            _12 = s;
            _22 = c;
        }
        public void RotationA(Vector3 vc)
        {
            float sr, sp, sy, cr, cp, cy;

            Identity();

            sy = (float)System.Math.Sin(vc.Z);
            cy = (float)System.Math.Cos(vc.Z);
            sp = (float)System.Math.Sin(vc.Y);
            cp = (float)System.Math.Cos(vc.Y);
            sr = (float)System.Math.Sin(vc.X);
            cr = (float)System.Math.Cos(vc.X);

            _11 = cp * cy;
            _12 = cp * sy;
            _13 = -sp;
            _21 = sr * sp * cy + cr * -sy;
            _22 = sr * sp * sy + cr * cy;
            _23 = sr * cp;
            _31 = (cr * sp * cy + -sr * -sy);
            _32 = (cr * sp * sy + -sr * cy);
            _33 = cr * cp;
        }
        public void RotationA(float x, float y, float z)
        {
            RotationA(new Vector3(x, y, z));
        }
        public void RotationArbi(Vector3 _vcAxis, float a)
        {
            Vector3 vcAxis = _vcAxis;
            float fCos = (float)System.Math.Cos(a);
            float fSin = (float)System.Math.Sin(a);
            float fSum = 1.0f - fCos;

            if (vcAxis.GetSqrLength() != 1.0)
                vcAxis.Normalize();

            _11 = (vcAxis.X * vcAxis.X) * fSum + fCos;
            _12 = (vcAxis.X * vcAxis.Y) * fSum - (vcAxis.Z * fSin);
            _13 = (vcAxis.X * vcAxis.Z) * fSum + (vcAxis.Y * fSin);

            _21 = (vcAxis.Y * vcAxis.X) * fSum + (vcAxis.Z * fSin);
            _22 = (vcAxis.Y * vcAxis.Y) * fSum + fCos;
            _23 = (vcAxis.Y * vcAxis.Z) * fSum - (vcAxis.X * fSin);

            _31 = (vcAxis.Z * vcAxis.X) * fSum - (vcAxis.Y * fSin);
            _32 = (vcAxis.Z * vcAxis.Y) * fSum + (vcAxis.X * fSin);
            _33 = (vcAxis.Z * vcAxis.Z) * fSum + fCos;

            _14 = _24 = _34 = _41 = _42 = _43 = 0.0f;
            _44 = 1.0f;
        }
        public void SetTranslation(Vector3 vc, bool b)
        {
            if (b)
            {
                Identity();
            }
            _41 = vc.X;
            _42 = vc.Y;
            _43 = vc.Z;
        }
        public Vector3 GetTranslation()
        {
            return new Vector3(_41, _42, _43);
        }
        public void Scale(float x, float y, float z)
        {// Load an Identity
            Identity();
            // Set the Translation matrix to the CO
            _11 = x;
            _22 = y;
            _33 = z;
        }
        public float GetDeterminant()
        {
            float res;
            res = _14 * _23 * _32 * _41 - _13 * _24 * _32 * _41 -
                    _14 * _22 * _33 * _41 + _12 * _24 * _33 * _41 +
                    _13 * _22 * _34 * _41 - _12 * _23 * _34 * _41 -
                    _14 * _23 * _31 * _42 + _13 * _24 * _31 * _42 +
                    _14 * _21 * _33 * _42 - _11 * _24 * _33 * _42 -
                    _13 * _21 * _34 * _42 + _11 * _23 * _32 * _42 +
                    _14 * _22 * _31 * _43 - _12 * _24 * _31 * _43 -
                    _14 * _21 * _32 * _43 + _11 * _24 * _32 * _43 +
                    _12 * _21 * _34 * _43 - _11 * _22 * _34 * _43 -
                    _13 * _22 * _31 * _44 + _12 * _23 * _31 * _44 +
                    _13 * _21 * _32 * _44 - _11 * _23 * _32 * _44 -
                    _12 * _21 * _33 * _44 + _11 * _22 * _33 * _44;
            return res;
        }
        public void CreateLookAt(Vector3 vPos, Vector3 vLookAt, Vector3 vUp)
        {
            Vector3 XAxis;
            Vector3 YAxis;
            Vector3 ZAxis;
            //Load an identity matrix
            Identity();
            //Make the Z axis
            ZAxis = vPos - vLookAt;
            ZAxis.Normalize();

            // Make the X axis
            // vUp.X = -vUp.X
            // vUp.Y = -vUp.Y
            // vUp.Z = -vUp.Z
            XAxis = vUp.Cross(ZAxis);
            XAxis.Normalize();

            // Make The Y
            YAxis = ZAxis.Cross(XAxis);

            // Fill The Matrix
            _11 = XAxis.X;
            _21 = XAxis.Y;
            _31 = XAxis.Z;

            _12 = YAxis.X;
            _22 = YAxis.Y;
            _32 = YAxis.Z;

            _13 = ZAxis.X;
            _23 = ZAxis.Y;
            _33 = ZAxis.Z;

            _41 = -XAxis.Dot(vPos);
            _42 = -YAxis.Dot(vPos);
            _43 = -ZAxis.Dot(vPos);
        }
        public void CreatePerspectiveFieldOfView(float FOV, float Aspect, float Near, float Far)
        {
            float sinFOV2 = (float)System.Math.Sin(FOV / 2);
            float cosFOV2 = (float)System.Math.Cos(FOV / 2);
            float w = Aspect * (cosFOV2 / sinFOV2);
            float h = 1.0f * (cosFOV2 / sinFOV2);
            float Q = Far / (Far - Near);
            Zero();
            _11 = w;
            _22 = h;
            _33 = Q;
            _34 = 1.0f;
            _43 = -Q * Near;
        }
        public void TransposeOf(Matrix mat)
        {
            // Set the Transpose matrix
            _11 = mat._11;
            _21 = mat._12;
            _31 = mat._13;
            _41 = mat._14;

            _12 = mat._21;
            _22 = mat._22;
            _32 = mat._23;
            _42 = mat._24;

            _13 = mat._31;
            _23 = mat._32;
            _33 = mat._33;
            _43 = mat._34;

            _14 = mat._41;
            _24 = mat._42;
            _34 = mat._43;
            _44 = mat._44;
        }
        public void InverseOf(Matrix a)
        {
            float Det = GetDeterminant();

            if (Det == 0)
                return;
            _11 = (a._22 * a._33 * a._44) + (a._23 * a._34 * a._42) + (a._24 * a._32 * a._43) - (a._22 * a._34 * a._43) - (a._23 * a._32 * a._44) - (a._24 * a._33 * a._42);
            _12 = (a._12 * a._34 * a._43) + (a._13 * a._32 * a._44) + (a._14 * a._33 * a._42) - (a._12 * a._33 * a._44) - (a._13 * a._34 * a._42) - (a._14 * a._32 * a._43);
            _13 = (a._12 * a._23 * a._44) + (a._13 * a._24 * a._42) + (a._14 * a._22 * a._43) - (a._12 * a._24 * a._43) - (a._13 * a._22 * a._44) - (a._14 * a._23 * a._42);
            _14 = (a._12 * a._24 * a._33) + (a._13 * a._22 * a._34) + (a._14 * a._23 * a._32) - (a._12 * a._23 * a._34) - (a._13 * a._24 * a._32) - (a._14 * a._22 * a._33);

            _21 = (a._21 * a._34 * a._43) + (a._23 * a._31 * a._44) + (a._24 * a._33 * a._41) - (a._21 * a._33 * a._44) - (a._23 * a._34 * a._41) - (a._24 * a._31 * a._43);
            _22 = (a._11 * a._33 * a._44) + (a._13 * a._34 * a._41) + (a._14 * a._31 * a._43) - (a._11 * a._34 * a._43) - (a._13 * a._31 * a._44) - (a._14 * a._33 * a._41);
            _23 = (a._11 * a._24 * a._43) + (a._13 * a._21 * a._44) + (a._14 * a._23 * a._41) - (a._11 * a._23 * a._44) - (a._13 * a._24 * a._41) - (a._14 * a._21 * a._43);
            _24 = (a._11 * a._23 * a._34) + (a._13 * a._24 * a._31) + (a._14 * a._21 * a._33) - (a._11 * a._24 * a._33) - (a._13 * a._21 * a._34) - (a._14 * a._23 * a._31);

            _31 = (a._21 * a._32 * a._44) + (a._22 * a._34 * a._41) + (a._24 * a._31 * a._42) - (a._21 * a._34 * a._42) - (a._22 * a._31 * a._44) - (a._24 * a._32 * a._41);
            _32 = (a._11 * a._34 * a._42) + (a._12 * a._31 * a._44) + (a._14 * a._32 * a._41) - (a._11 * a._32 * a._44) - (a._12 * a._34 * a._41) - (a._14 * a._31 * a._42);
            _33 = (a._11 * a._22 * a._44) + (a._12 * a._24 * a._41) + (a._14 * a._21 * a._42) - (a._11 * a._24 * a._42) - (a._12 * a._21 * a._44) - (a._14 * a._22 * a._41);
            _34 = (a._11 * a._24 * a._32) + (a._12 * a._21 * a._34) + (a._14 * a._22 * a._31) - (a._11 * a._22 * a._34) - (a._12 * a._24 * a._31) - (a._14 * a._21 * a._32);

            _41 = (a._21 * a._33 * a._42) + (a._22 * a._31 * a._43) + (a._23 * a._32 * a._41) - (a._21 * a._32 * a._43) - (a._22 * a._33 * a._41) - (a._23 * a._31 * a._42);
            _42 = (a._11 * a._32 * a._43) + (a._12 * a._33 * a._41) + (a._13 * a._31 * a._42) - (a._11 * a._33 * a._42) - (a._12 * a._31 * a._43) - (a._13 * a._32 * a._41);
            _43 = (a._11 * a._23 * a._42) + (a._12 * a._21 * a._43) + (a._13 * a._22 * a._41) - (a._11 * a._22 * a._43) - (a._12 * a._23 * a._41) - (a._13 * a._21 * a._42);
            _44 = (a._11 * a._22 * a._33) + (a._12 * a._23 * a._31) + (a._13 * a._21 * a._32) - (a._11 * a._23 * a._32) - (a._12 * a._21 * a._33) - (a._13 * a._22 * a._31);
        }

        #endregion

        #region " Operators "

        public static Vector3 operator *(Matrix mat, Vector3 vec)
        {
            Vector3 res = new Vector3();
            float w;

            res.X = vec.X * mat._11 + vec.Y * mat._21 + vec.Z * mat._31 + mat._41;
            res.Y = vec.X * mat._12 + vec.Y * mat._22 + vec.Z * mat._32 + mat._42;
            res.Z = vec.X * mat._13 + vec.Y * mat._23 + vec.Z * mat._33 + mat._43;
            w = vec.X * mat._14 + vec.Y * mat._24 + vec.Z * mat._34 + mat._44;

            res.X = res.X / w;
            res.Y = res.Y / w;
            res.Z = res.Z / w;

            return res;
        }
        public static Vector3 operator *(Vector3 vec, Matrix mat)
        {
            Vector3 res = new Vector3();
            float w;

            res.X = vec.X * mat._11 + vec.Y * mat._21 + vec.Z * mat._31 + mat._41;
            res.Y = vec.X * mat._12 + vec.Y * mat._22 + vec.Z * mat._32 + mat._42;
            res.Z = vec.X * mat._13 + vec.Y * mat._23 + vec.Z * mat._33 + mat._43;
            w = vec.X * mat._14 + vec.Y * mat._24 + vec.Z * mat._34 + mat._44;

            res.X = res.X / w;
            res.Y = res.Y / w;
            res.Z = res.Z / w;

            return res;
        }
        public static Matrix operator *(Matrix mat1, Matrix mat2)
        {
	        Matrix mResult = new Matrix();
            // Multiply the 2 matrices
	        return mResult;
        }
        public static Matrix operator *(Matrix mat, float num)
        {
            Matrix res = new Matrix();
            // Multiply all the Enteries by the Scalar
            res._11 = mat._11 * num;
            res._12 = mat._12 * num;
            res._13 = mat._13 * num;
            res._14 = mat._14 * num;

            res._21 = mat._21 * num;
            res._22 = mat._22 * num;
            res._23 = mat._23 * num;
            res._24 = mat._24 * num;

            res._31 = mat._31 * num;
            res._32 = mat._32 * num;
            res._33 = mat._33 * num;
            res._34 = mat._34 * num;

            res._41 = mat._41 * num;
            res._42 = mat._42 * num;
            res._43 = mat._43 * num;
            res._44 = mat._44 * num;
            return res;
        }
        public static Matrix operator *(float num, Matrix mat)
        {
            Matrix res = new Matrix();
            // Multiply all the Enteries by the Scalar
            res._11 = mat._11 * num;
            res._12 = mat._12 * num;
            res._13 = mat._13 * num;
            res._14 = mat._14 * num;

            res._21 = mat._21 * num;
            res._22 = mat._22 * num;
            res._23 = mat._23 * num;
            res._24 = mat._24 * num;

            res._31 = mat._31 * num;
            res._32 = mat._32 * num;
            res._33 = mat._33 * num;
            res._34 = mat._34 * num;

            res._41 = mat._41 * num;
            res._42 = mat._42 * num;
            res._43 = mat._43 * num;
            res._44 = mat._44 * num;
            return res;
        }
        public static Matrix operator /(Matrix mat, float num)
        {
            Matrix res = new Matrix();
            // Devide all the Enteries by the Scalar
            res._11 = mat._11 / num;
            res._12 = mat._12 / num;
            res._13 = mat._13 / num;
            res._14 = mat._14 / num;

            res._21 = mat._21 / num;
            res._22 = mat._22 / num;
            res._23 = mat._23 / num;
            res._24 = mat._24 / num;

            res._31 = mat._31 / num;
            res._32 = mat._32 / num;
            res._33 = mat._33 / num;
            res._34 = mat._34 / num;

            res._41 = mat._41 / num;
            res._42 = mat._42 / num;
            res._43 = mat._43 / num;
            res._44 = mat._44 / num;
            return res;
        }
        public static Matrix operator /(float num, Matrix mat)
        {
            Matrix res = new Matrix();
            // Devide all the Enteries by the Scalar
            res._11 = mat._11 / num;
            res._12 = mat._12 / num;
            res._13 = mat._13 / num;
            res._14 = mat._14 / num;

            res._21 = mat._21 / num;
            res._22 = mat._22 / num;
            res._23 = mat._23 / num;
            res._24 = mat._24 / num;

            res._31 = mat._31 / num;
            res._32 = mat._32 / num;
            res._33 = mat._33 / num;
            res._34 = mat._34 / num;

            res._41 = mat._41 / num;
            res._42 = mat._42 / num;
            res._43 = mat._43 / num;
            res._44 = mat._44 / num;
            return res;
        }
        public static Matrix operator +(Matrix mat1,  Matrix mat2) 
        {
            Matrix res = new Matrix();
	        // Add the 2 Matrices
            res._11 = mat1._11 + mat2._11;
            res._12 = mat1._12 + mat2._12;
            res._13 = mat1._13 + mat2._13;
            res._14 = mat1._14 + mat2._14;

            res._21 = mat1._21 + mat2._21;
            res._22 = mat1._22 + mat2._22;
            res._23 = mat1._23 + mat2._23;
            res._24 = mat1._24 + mat2._24;

            res._31 = mat1._31 + mat2._31;
            res._32 = mat1._32 + mat2._32;
            res._33 = mat1._33 + mat2._33;
            res._34 = mat1._34 + mat2._34;

            res._41 = mat1._41 + mat2._41;
            res._42 = mat1._42 + mat2._42;
            res._43 = mat1._43 + mat2._43;
            res._44 = mat1._44 + mat2._44;
	        return res;
        }
        public static Matrix operator +(Matrix mat, float num)
        {
            Matrix res = new Matrix();
            // Add the matrix by the scalar
            res._11 = mat._11 + num;
            res._12 = mat._12 + num;
            res._13 = mat._13 + num;
            res._14 = mat._14 + num;

            res._21 = mat._21 + num;
            res._22 = mat._22 + num;
            res._23 = mat._23 + num;
            res._24 = mat._24 + num;

            res._31 = mat._31 + num;
            res._32 = mat._32 + num;
            res._33 = mat._33 + num;
            res._34 = mat._34 + num;

            res._41 = mat._41 + num;
            res._42 = mat._42 + num;
            res._43 = mat._43 + num;
            res._44 = mat._44 + num;
            return res;
        }
        public static Matrix operator +(float num, Matrix mat)
        {
            Matrix res = new Matrix();
            // Add the matrix by the scalar
            res._11 = mat._11 + num;
            res._12 = mat._12 + num;
            res._13 = mat._13 + num;
            res._14 = mat._14 + num;

            res._21 = mat._21 + num;
            res._22 = mat._22 + num;
            res._23 = mat._23 + num;
            res._24 = mat._24 + num;

            res._31 = mat._31 + num;
            res._32 = mat._32 + num;
            res._33 = mat._33 + num;
            res._34 = mat._34 + num;

            res._41 = mat._41 + num;
            res._42 = mat._42 + num;
            res._43 = mat._43 + num;
            res._44 = mat._44 + num;
            return res;
        }
        public static Matrix operator -(Matrix mat1, Matrix mat2)
        {
            Matrix res = new Matrix();
            // Subtract the 2 Matrices
            res._11 = mat1._11 - mat2._11;
            res._12 = mat1._12 - mat2._12;
            res._13 = mat1._13 - mat2._13;
            res._14 = mat1._14 - mat2._14;

            res._21 = mat1._21 - mat2._21;
            res._22 = mat1._22 - mat2._22;
            res._23 = mat1._23 - mat2._23;
            res._24 = mat1._24 - mat2._24;

            res._31 = mat1._31 - mat2._31;
            res._32 = mat1._32 - mat2._32;
            res._33 = mat1._33 - mat2._33;
            res._34 = mat1._34 - mat2._34;

            res._41 = mat1._41 - mat2._41;
            res._42 = mat1._42 - mat2._42;
            res._43 = mat1._43 - mat2._43;
            res._44 = mat1._44 - mat2._44;
	        return res;
        }
        public static Matrix operator -(Matrix mat, float num)
        {
            Matrix res = new Matrix();
            // Subtract the matrix by the scalar
            res._11 = mat._11 - num;
            res._12 = mat._12 - num;
            res._13 = mat._13 - num;
            res._14 = mat._14 - num;

            res._21 = mat._21 - num;
            res._22 = mat._22 - num;
            res._23 = mat._23 - num;
            res._24 = mat._24 - num;

            res._31 = mat._31 - num;
            res._32 = mat._32 - num;
            res._33 = mat._33 - num;
            res._34 = mat._34 - num;

            res._41 = mat._41 - num;
            res._42 = mat._42 - num;
            res._43 = mat._43 - num;
            res._44 = mat._44 - num;
            return res;
        }
        public static Matrix operator -(float num, Matrix mat)
        {
            Matrix res = new Matrix();
            // Subtract the matrix by the scalar
            res._11 = mat._11 - num;
            res._12 = mat._12 - num;
            res._13 = mat._13 - num;
            res._14 = mat._14 - num;

            res._21 = mat._21 - num;
            res._22 = mat._22 - num;
            res._23 = mat._23 - num;
            res._24 = mat._24 - num;

            res._31 = mat._31 - num;
            res._32 = mat._32 - num;
            res._33 = mat._33 - num;
            res._34 = mat._34 - num;

            res._41 = mat._41 - num;
            res._42 = mat._42 - num;
            res._43 = mat._43 - num;
            res._44 = mat._44 - num;
            return res;
        }

        #endregion
    }
}
