﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class MathHelper
    {
        #region " Constants "

        public const float PI = 3.14159265f;
        public const float PI2 = 6.2831853f;
        public const float PIOver2 = 1.57079633f;
        public const float PIOver3 = 1.04719755f;
        public const float PIOver4 = 0.785398163f;
        public const float PIOver8 = 0.392699082f;
        public const float Epsilon = .0000001f;

        #endregion

        #region " Methods "

        public static bool IsZero(float X)
        {
            if ((X >= -Epsilon) & (X <= Epsilon))
                return true;
            return false;
        }

        public static float Sqrt(float X)
        {
            return (float)Math.Sqrt(X);
        }

        public static float Cbrt(float X)
        {
            return (float)Math.Pow(X, (1/3));
        }

        public static float Acos(float X)
        {
            return (float)Math.Acos(X);
        }

        public static float Cos(float X)
        {
            return (float)Math.Cos(X);
        }

        #endregion
    }
}
