﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Vertex
    {
        #region " Variables "

        public Vector3 m_Position;
        public Vector3 m_Normal;
        public Colorf m_Color;
        public Vector2 m_UV;

        #endregion

        #region " Constructors "

        public Vertex()
        {
            // Set up the default values
            m_Position = new Vector3();
            m_Normal = new Vector3();
            m_Color = new Colorf();
            m_UV = new Vector2();
        }

        public Vertex(Vector3 pos,Vector3 norm, Colorf col, Vector2 uv)
        {
            // Set up the new values
            m_Position = pos;
            m_Normal = norm;
            m_Color = col;
            m_UV = uv;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 pos, Vector3 norm, Colorf col, Vector2 uv)
        {
            // Set up the new values
            m_Position = pos;
            m_Normal = norm;
            m_Color = col;
            m_UV = uv;
        }
        public bool IsEqual(Vertex v)
        {
            // Checkl if the pos, col, and uv are the same
            if ((m_Position.X == v.m_Position.X) & (m_Position.Y == v.m_Position.Y) & (m_Position.Z == v.m_Position.Z) &
                (m_UV.X == v.m_UV.X) & (m_UV.Y == v.m_UV.Y) & (m_Color.A == v.m_Color.A) &
                (m_Color.R == v.m_Color.R) &(m_Color.G == v.m_Color.G) &(m_Color.B == v.m_Color.B))
                return true;
            return false;
        }

        #endregion

        #region " Interpolation "

        public Vertex Interpolate(Vector3 pos, Vertex v1, Vertex v2)
        {
            return new Vertex();
        }
        public Vertex Interpolate(Vector3 pos, Vertex v1, Vertex v2, Vertex v3)
        {
            float D1, D2, D3, DA, DB, W1, W2, W3;
            Vector3 P = new Vector3();
            Vector2 UV = new Vector2();
            Vector3 Norm = new Vector3();
            Colorf col = new Colorf(0,0,0,0);

            //Find the First Weight
            D1 = System.Math.Abs(pos.Distance(pos, v1.m_Position));
            P = P.GetClosetPoint(v2.m_Position, v3.m_Position, pos, true);
            DA = System.Math.Abs(pos.Distance(P, v1.m_Position));
            W1 = -1 + D1 / DA;
            //Find The Second Weight
            D2 = System.Math.Abs(pos.Distance(pos, v2.m_Position));
            P = P.GetClosetPoint(v3.m_Position, v1.m_Position, pos, true);
            DA = System.Math.Abs(pos.Distance(v2.m_Position, P));
            W2 = -1 + D2 / DA;
            //Find the third weight
            D3 = System.Math.Abs(pos.Distance(pos, v3.m_Position));
            P = P.GetClosetPoint(v2.m_Position, v1.m_Position, pos, true);
            DA = System.Math.Abs(pos.Distance(v3.m_Position, P));
            W3 = -1 + D3 / DA;

            // Make the Weights sum 1
            DB = W1 + W2 + W3;
            W1 /= DB;
            W2 /= DB;
            W3 /= DB;

            // Calculate the Normal
            Norm = v1.m_Normal * W1 + v2.m_Normal * W2 + v3.m_Normal * W3;

            // Calculate the Color
            col = v1.m_Color * W1 + v2.m_Color * W2 + v3.m_Color * W3;

            // Calculate the UV
            UV = v1.m_UV * W1 + v2.m_UV * W2 + v3.m_UV * W3;

            // Return the New blended Vertex point
            return new Vertex(pos, Norm, col, UV);
        }

        #endregion
    }
}
