﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Plane
    {
        #region " Varaibles "


        public Vector3 m_Normal;     // plane normal vector
        public Vector3 m_Point;      // point on plane
        public float m_Distance;	 // distance to origin

        #endregion

        #region " Constructors "

        public Plane()
        {
	        // Set the default values
	        m_Normal = new Vector3();
	        m_Point = new Vector3();
	        m_Distance = 0.0f;
        }
        public Plane(Vector3 norm, Vector3 point)
        {
	        // Set the new Values
	        m_Distance  = -(norm.Dot(point));
	        m_Normal    = norm;
	        m_Point		= point;
        }
        public Plane(Vector3 norm, Vector3 point, float distance)
        {
            // Set the new Values
            m_Distance = distance;
            m_Normal = norm;
            m_Point = point;
        }
        public Plane(Vector3 v0, Vector3 v1, Vector3 v2)
        {
            // Construct the plane useing the 3 points
            Vector3 vcEdge1 = v0 - v1;
            Vector3 vcEdge2 = v2 - v0;

            m_Normal = vcEdge1.Cross(vcEdge2);
            m_Normal.Normalize();
            m_Distance = -(m_Normal.Dot(v0));
            m_Point = v0;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 norm, Vector3 point)
        {
	        // Set the new Values
	        m_Distance  = - ( norm.Dot(point));
	        m_Normal    = norm;
	        m_Point		= point;
        }
        public void Set(Vector3 norm, Vector3 point, float distance)
        {
	        // Set the new Values
	        m_Distance  = distance;
	        m_Normal    = norm;
	        m_Point		= point;
        }
        public void Set(Vector3 v0, Vector3 v1, Vector3 v2)
        {
	        // Construct the plane useing the 3 points
	        Vector3 vcEdge1 = v1 - v0;
	        Vector3 vcEdge2 = v2 - v0;

	        m_Normal = vcEdge1.Cross(vcEdge2);
	        m_Normal.Normalize();
	        m_Distance = - (m_Normal.Dot(v0));
	        m_Point = v0;
        }
        public float Distance(Vector3 point)
        {
	        return  System.Math.Abs((m_Normal.Dot(point)) - m_Distance);
        }

        #endregion
    }
}
