﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Disc
    {
        #region " Varaibles "


        public Plane m_Plane;       // plane vector
        public Vector3 m_Center;    // Center of the disc
        public float m_Radius;	    // Radius

        #endregion

        #region " Constructors "

        public Disc()
        {
	        // Set the default values
            m_Plane = new Plane();
            m_Center = new Vector3();
            m_Radius = 0.0f;
        }
        public Disc(Plane plane, Vector3 center, float radius)
        {
            // Set the new Values
            m_Plane = plane;
            m_Plane.m_Distance = -(m_Plane.m_Normal.Dot(center));
            m_Center = center;
            m_Radius = radius;
        }
        public Disc(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius)
        {
            m_Plane = new Plane(v1, v2, v3);
            m_Plane.m_Distance = -(m_Plane.m_Normal.Dot(center));
            m_Center = center;
            m_Radius = radius;
        }

        #endregion

        #region " Methods "

        public void Set(Plane plane, Vector3 center, float radius)
        {
            // Set the new Values
            m_Plane = plane;
            m_Plane.m_Distance = -(m_Plane.m_Normal.Dot(center));
            m_Center = center;
            m_Radius = radius;
        }
        public void Set(Vector3 v1, Vector3 v2, Vector3 v3, Vector3 center, float radius)
        {
            m_Plane = new Plane(v1, v2, v3);
            m_Plane.m_Distance = -(m_Plane.m_Normal.Dot(center));
            m_Center = center;
            m_Radius = radius;
        }

        #endregion
    }
}
