﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Hermite
    {
        #region " Variables "

        public Vector3 m_P1;
        public Vector3 m_P2;
        public Vector3 m_T1;
        public Vector3 m_T2;

        #endregion

        #region " Constructors "

        public Hermite()
        {
            // Set the default values
            m_P1 = new Vector3();
            m_P2 = new Vector3();
            m_T1 = new Vector3();
            m_T2 = new Vector3();
        }

        public Hermite(Vector3 p1, Vector3 p2, Vector3 t1, Vector3 t2)
        {
            // Set the new values
            m_P1 = p1;
            m_P2 = p2;
            m_T1 = t1;
            m_T2 = t2;
        }

        public Hermite(Hermite last)
        {
            // Set the new values as the Last part of the curve
            m_P1 = last.m_P2;
            m_P2 = new Vector3();
            m_T1 = last.m_T2;
            m_T1.Negate();
            m_T2 = new Vector3();
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 p1, Vector3 p2, Vector3 t1, Vector3 t2)
        {
            // Set the new values
            m_P1 = p1;
            m_P2 = p2;
            m_T1 = t1;
            m_T2 = t2;
        }

        public void SetStart(Hermite last)
        {
            // Set the new values as the Last part of the curve
            m_P1 = last.m_P2;
            m_T1 = last.m_T2;
            m_T1.Negate();
        }

        public Vector3 GetPosition(float T)
        {
            // Make sure T is between 0 and 1
            if (T > 1)
                T = 1;
            if (T < 0)
                T = 0;
            float T2 = T-1;
            Vector3 res = new Vector3();
            // Calculate the Position
            res = (1 - 3 * T * T + 2 * T * T * T) * m_P1 + T * T*(3 - 2 * T) * m_P2 + T * T2 * T2 * m_T1 + T * T * T2 * m_T2;
            return res;
        }

        #endregion
    }
}
