﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Bezier
    {
        #region " Variables "

        public Vector3 m_P1;
        public Vector3 m_P2;
        public Vector3 m_P3;
        public Vector3 m_P4;

        #endregion

        #region " Constructors "

        public Bezier()
        {
            // Set the default values
            m_P1 = new Vector3();
            m_P2 = new Vector3();
            m_P3 = new Vector3();
            m_P4 = new Vector3();
        }

        public Bezier(Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4)
        {
            // Set the default values
            m_P1 = p1;
            m_P2 = p2;
            m_P3 = p3;
            m_P4 = p4;
        }

        #endregion

        #region " Methods "

        public void Set(Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4)
        {
            // Set the default values
            m_P1 = p1;
            m_P2 = p2;
            m_P3 = p3;
            m_P4 = p4;
        }

        public Vector3 GetPosition(float T)
        {
            // Make sure T is between 0 and 1
            if (T > 1)
                T = 1;
            if (T < 0)
                T = 0;
            float T2 = 1 - T;
            Vector3 res = new Vector3();
            // Calculate the Position
            res = m_P1 * T2 * T2 * T2 + m_P2 * 3 * T * T2 * T2 + m_P3 * 3 * T * T * T2 + m_P4 * T * T * T;
            return res;
        }

        #endregion
    }
}
