﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace BLSpaceRay.Math3D
{
    public class Colorf
    {
        #region " Variables "

        public float A;
        public float R;
        public float G;
        public float B;

        #endregion

        #region " Constructors "

        public Colorf()
        {
            // Set the default values
            A = 1f;
            R = 0f;
            G = 0f;
            B = 0f;
        }
        public Colorf(float _r, float _g, float _b)
        {
            // Set the new values
            A = 1f;
            R = _r;
            G = _g;
            B = _b;
        }
        public Colorf(float _a, float _r, float _g, float _b)
        {
            // Set the new values
            A = _a;
            R = _r;
            G = _g;
            B = _b;
        }
        public Colorf(Color c)
        {
            // Set the new values
            A = (float)c.A / 255;
            R = (float)c.R / 255;
            G = (float)c.G / 255;
            B = (float)c.B / 255;
        }

        #endregion

        #region " Methods "

        private void Clamp()
        {
            //Check the Alpha over 1
            if (A > 1)
                A = 1;
            //Check the Alpha under 0
            if (A < 0)
                A = 0;
            //Check the Red over 1
            if (R > 1)
                R = 1;
            //Check the Red under 0
            if (R < 0)
                R = 0;
            //Check the Green over 1
            if (G > 1)
                G = 1;
            //Check the Green under 0
            if (G < 0)
                G = 0;
            //Check the Blue over 1
            if (B > 1)
                B = 1;
            //Check the Blue under 0
            if (B < 0)
                B = 0;
        }

        public Color ToSystemColor()
        {
            int a, r, g, b;
            a = r = g = b = 0;
            // Clamp the variables
            Clamp();
            a = 255;
            r = (byte)(R * 255);
            g = (byte)(G * 255);
            b = (byte)(B * 255);
            return Color.FromArgb(a, r, g, b);
        }

        #endregion

        #region " Operators "

        public static Colorf operator *(Colorf c1, Colorf c2)
        {
            return new Colorf(c1.A * c2.A, c1.R * c2.R, c1.G * c2.G, c1.B * c2.B);
        }
        public static Colorf operator *(Colorf c, float s)
        {
            return new Colorf(c.A * s, c.R * s, c.G * s, c.B * s);
        }
        public static Colorf operator *(float s, Colorf c)
        {
            return new Colorf(c.A * s, c.R * s, c.G * s, c.B * s);
        }
        public static Colorf operator /(Colorf c1, Colorf c2)
        {
            return new Colorf(c1.A / c2.A, c1.R / c2.R, c1.G / c2.G, c1.B / c2.B);
        }
        public static Colorf operator /(Colorf c, float s)
        {
            return new Colorf(c.A / s, c.R / s, c.G / s, c.B / s);
        }
        public static Colorf operator /(float s, Colorf c)
        {
            return new Colorf(c.A / s, c.R / s, c.G / s, c.B / s);
        }
        public static Colorf operator -(Colorf c1, Colorf c2)
        {
            return new Colorf(c1.A - c2.A, c1.R - c2.R, c1.G - c2.G, c1.B - c2.B);
        }
        public static Colorf operator -(Colorf c, float s)
        {
            return new Colorf(c.A - s, c.R - s, c.G - s, c.B - s);
        }
        public static Colorf operator -(float s, Colorf c)
        {
            return new Colorf(c.A - s, c.R - s, c.G - s, c.B - s);
        }
        public static Colorf operator +(Colorf c1, Colorf c2)
        {
            return new Colorf(c1.A + c2.A, c1.R + c2.R, c1.G + c2.G, c1.B + c2.B);
        }
        public static Colorf operator +(Colorf c, float s)
        {
            return new Colorf(c.A + s, c.R + s, c.G + s, c.B + s);
        }
        public static Colorf operator +(float s, Colorf c)
        {
            return new Colorf(c.A + s, c.R + s, c.G + s, c.B + s);
        }

        #endregion
    }
}
