﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BLSpaceRay.Math3D
{
    public class Camera
    {
        public Matrix m_View = new Matrix();
        public Vector3 m_CameraPosition = new Vector3();

        public float speed = 1f;

        // Max yaw/pitch variables
        float totalYaw = 4;
        float currentYaw = 0;
        float totalPitch = 4;
        float currentPitch = 0;
        float totalRoll = 4;
        float currentRoll = 0;

        protected Vector3 cameraDirection = new Vector3();
        protected Vector3 cameraUp = new Vector3();
        protected Vector3 cameraRight = new Vector3();

        public Camera(Vector3 pos, Vector3 target, Vector3 up, float Aspect)
        {
            // Build camera view matrix
            m_CameraPosition = pos;
            cameraDirection = target - pos;
            cameraDirection.Normalize();
            cameraRight = cameraUp.Cross(cameraDirection);
            cameraRight.Normalize();
            cameraUp = up;
            Update();
        }

        public void YawRotation(float yawAngle)
        {
            Matrix m = new Matrix();
            // Yaw rotation
            if (totalYaw > 3.14)
            {
                m.RotationArbi(cameraUp, yawAngle);
                cameraDirection.RotateWith(m);
            }
            else if (System.Math.Abs(currentYaw + yawAngle) < totalYaw)
            {
                m.RotationArbi(cameraUp, yawAngle);
                cameraDirection.RotateWith(m);
                currentYaw += yawAngle;
            }
            Update();
        }

        public void PitchRotation(float pitchAngle)
        {
            Matrix m = new Matrix();
            if (totalPitch > 3.14)
            {
                m.RotationArbi(cameraRight, pitchAngle);
                cameraDirection.RotateWith(m);
            }
            else if (System.Math.Abs(currentPitch + pitchAngle) < totalPitch)
            {
                m.RotationArbi(cameraRight, pitchAngle);
                cameraDirection.RotateWith(m);
                currentPitch += pitchAngle;
            }
            Update();
        }

        public void RollRotation(float rollAngle)
        {
            Matrix m = new Matrix();
            if (totalRoll > 3.14)
            {
                m.RotationArbi(cameraDirection, rollAngle);
                cameraUp.RotateWith(m);
            }
            else if (System.Math.Abs(currentRoll + rollAngle) < totalRoll)
            {
                m.RotationArbi(cameraDirection, rollAngle);
                cameraUp.RotateWith(m);
                currentRoll += rollAngle;
            }
            Update();
        }

        public void Fly(float xd, float yd, float zd)
        {
            if (xd != 0)
            {
                m_CameraPosition += cameraRight * xd;
            }
            if (yd != 0)
            {
                m_CameraPosition += cameraUp * yd;
            }
            if (zd != 0)
            {
                m_CameraPosition += cameraDirection * zd;
            }
            Update();
        }

        public void FlyYClamped(float xd, float yd, float zd)
        {
            if (zd != 0)
            {
                m_CameraPosition.X += cameraDirection.X * zd;
                m_CameraPosition.Z += cameraDirection.Z * zd;
            }
            if (xd != 0)
            {
                m_CameraPosition.X += cameraRight.X * xd;
                m_CameraPosition.Z += cameraRight.Z * xd;
            }
            Update();
        }

        private void Update()
        {
            m_View.CreateLookAt(m_CameraPosition, m_CameraPosition + cameraDirection, cameraUp);

            cameraRight = cameraUp.Cross(cameraDirection);
            cameraRight.Normalize();


            cameraRight = cameraUp.Cross(cameraDirection);
            cameraRight.Normalize();

        }
    }
}
